/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.excel;

import com.xebialabs.xlrelease.excel.Export;
import com.xebialabs.xlrelease.reports.UserParticipation;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class TopPeopleMostInvolvedExport
extends Export {
    private List<UserParticipation> topPeopleMostInvolved;
    public static final int PERSON_COLUMN = 0;
    public static final int DURATION_COLUMN = 1;
    public static final int TASK_HANDLED_COLUMN = 2;
    private static final String PERSON_HEADER = "Person";
    private static final String DURATION_HEADER = "Time spent";
    private static final String TASK_HANDLED_HEADER = "Task handled";

    public TopPeopleMostInvolvedExport(List<UserParticipation> topPeopleMostInvolved) {
        this.topPeopleMostInvolved = topPeopleMostInvolved;
    }

    @Override
    protected void addContent() {
        for (UserParticipation userParticipation : this.topPeopleMostInvolved) {
            XSSFRow row = this.sheet.createRow(this.rowIndex++);
            String user = userParticipation.getUser().getFullName();
            if (user == null) {
                user = userParticipation.getUser().getUsername();
            }
            CellUtil.createCell((Row)row, (int)0, (String)user);
            XSSFCell duration = row.createCell(1);
            duration.setCellValue((double)userParticipation.getTimeSpent());
            XSSFCell taskHandled = row.createCell(2);
            taskHandled.setCellValue((double)userParticipation.getTasksHandled());
        }
    }

    @Override
    protected void setColumnsWidth() {
        this.sheet.setColumnWidth(0, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(1, this.numberOfCharacter(15));
        this.sheet.setColumnWidth(2, this.numberOfCharacter(15));
    }

    @Override
    protected void addHeaderRow() {
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        CellUtil.createCell((Row)row, (int)0, (String)PERSON_HEADER);
        CellUtil.createCell((Row)row, (int)1, (String)DURATION_HEADER);
        CellUtil.createCell((Row)row, (int)2, (String)TASK_HANDLED_HEADER);
        this.sheet.createRow(this.rowIndex++);
    }
}

