/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.CiMemoryReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class CiCloneHelper {
    @Timed
    public static <T extends ConfigurationItem> T cloneCi(T ci) {
        Map<String, ConfigurationItem> cisWithRewrittenNullId = CiCloneHelper.replaceNullIds(ci);
        InMemoryRepository externalReferences = new InMemoryRepository(CiHelper.getExternalReferences(ci));
        ConfigurationItemConverter ciConverter = new ConfigurationItemConverter();
        CiMemoryReader ciReader = new CiMemoryReader(ci);
        ConfigurationItem clonedCi = ciConverter.readCi((CiReader)ciReader);
        ciConverter.resolveReferences((Repository)externalReferences);
        CiCloneHelper.nullifyReplacedIds(ci, cisWithRewrittenNullId);
        CiCloneHelper.nullifyReplacedIds(clonedCi, cisWithRewrittenNullId);
        return (T)clonedCi;
    }

    @Timed
    public static <T extends ConfigurationItem> List<T> cloneCis(List<T> ciList) {
        return ciList.stream().map(CiCloneHelper::cloneCi).collect(Collectors.toList());
    }

    private static Map<String, ConfigurationItem> replaceNullIds(ConfigurationItem parentCi) {
        HashMap<String, ConfigurationItem> replaced = new HashMap<String, ConfigurationItem>();
        CiHelper.getNestedCis((ConfigurationItem)parentCi).stream().filter(ci -> ci.getId() == null).forEach(ci -> {
            String temporaryId = UUID.randomUUID().toString();
            ci.setId(temporaryId);
            replaced.put(temporaryId, (ConfigurationItem)ci);
        });
        return replaced;
    }

    private static void nullifyReplacedIds(ConfigurationItem parentCi, Map<String, ConfigurationItem> replacedMapping) {
        CiHelper.getNestedCis((ConfigurationItem)parentCi).forEach(ci -> {
            if (replacedMapping.containsKey(ci.getId())) {
                ci.setId(null);
            }
        });
    }

    static class InMemoryRepository
    implements Repository {
        private Map<String, ConfigurationItem> cis;

        InMemoryRepository(Collection<ConfigurationItem> cis) {
            this.cis = new HashMap<String, ConfigurationItem>(cis.size());
            cis.forEach(ci -> this.cis.put(ci.getId(), (ConfigurationItem)ci));
        }

        public boolean exists(String id) {
            return this.cis.containsKey(id);
        }

        public <T extends ConfigurationItem> T read(String id) {
            return (T)this.cis.get(id);
        }

        public <T extends ConfigurationItem> void create(T[] entity) {
            throw new RuntimeException("Not supported in InMemoryRepository");
        }

        public <T extends ConfigurationItem> void update(T[] entity) {
            throw new RuntimeException("Not supported in InMemoryRepository");
        }

        public <T extends ConfigurationItem> void createOrUpdate(T[] entity) {
            throw new RuntimeException("Not supported in InMemoryRepository");
        }

        public void delete(String ... id) {
            throw new RuntimeException("Not supported in InMemoryRepository");
        }

        public void move(String id, String newId) {
            throw new RuntimeException("Not supported in InMemoryRepository");
        }

        public void rename(String id, String newName) {
            throw new RuntimeException("Not supported in InMemoryRepository");
        }

        public <T extends ConfigurationItem> List<T> search(Type type) {
            throw new RuntimeException("Not supported in InMemoryRepository");
        }

        public <T extends ConfigurationItem> List<T> search(Type type, String parent) {
            throw new RuntimeException("Not supported in InMemoryRepository");
        }
    }
}

