/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import com.google.common.base.Strings;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationService {
    private AuthenticationManager authenticationManager;
    private ThreadLocal<Authentication> authenticationThreadLocal = new ThreadLocal();

    @Autowired
    public AuthenticationService(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void loginScriptUser(Task task) {
        String scriptUser = task.getRelease().getScriptUsername();
        String scriptUserPassword = PasswordEncrypter.getInstance().ensureDecrypted(task.getRelease().getScriptUserPassword());
        this.authenticationThreadLocal.set(SecurityContextHolder.getContext().getAuthentication());
        if (!Strings.isNullOrEmpty((String)scriptUser)) {
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)scriptUser, (Object)Strings.nullToEmpty((String)scriptUserPassword));
            Authentication authentication = this.authenticationManager.authenticate((Authentication)usernamePasswordAuthenticationToken);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
    }

    public void logoutScriptUser() {
        SecurityContextHolder.getContext().setAuthentication(this.authenticationThreadLocal.get());
    }
}

