/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams$;
import com.xebialabs.xlrelease.repository.ReleaseTriggerRepository;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t5g\u0001B\u0001\u0003\u0001-\u0011QBR8mI\u0016\u00148+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012!B:mMRR'\"A\f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0007\u000b\u0003\u000f1{wmZ5oO\"A1\u0004\u0001B\u0001B\u0003%A$A\u0004g_2$WM]:\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011E\b\u0002\u0011\r>dG-\u001a:SKB|7/\u001b;pefD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\fi\u0016\fWnU3sm&\u001cW\r\u0005\u0002&M5\t!!\u0003\u0002(\u0005\tYA+Z1n'\u0016\u0014h/[2f\u0011!I\u0003A!A!\u0002\u0013Q\u0013!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011QdK\u0005\u0003Yy\u0011\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011!q\u0003A!A!\u0002\u0013y\u0013a\u0003;bg.\u001cVM\u001d<jG\u0016\u0004\"!\n\u0019\n\u0005E\u0012!a\u0003+bg.\u001cVM\u001d<jG\u0016D\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\fG&LEmU3sm&\u001cW\r\u0005\u0002&k%\u0011aG\u0001\u0002\f\u0007&LEmU3sm&\u001cW\r\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0003Q\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dKB\u0011QEO\u0005\u0003w\t\u0011ACU3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,\u0007\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002\u0017A,'/\\5tg&|gn\u001d\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u0012\t\u0001b]3dkJLG/_\u0005\u0003\u0007\u0002\u0013\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u0011!)\u0005A!A!\u0002\u00131\u0015\u0001C3wK:$()^:\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%#\u0011AB3wK:$8/\u0003\u0002L\u0011\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\t\u00115\u0003!\u0011!Q\u0001\n9\u000b\u0011D]3mK\u0006\u001cX\r\u0016:jO\u001e,'o\u001d*fa>\u001c\u0018\u000e^8ssB\u0011QdT\u0005\u0003!z\u0011\u0001DU3mK\u0006\u001cX\r\u0016:jO\u001e,'OU3q_NLGo\u001c:z\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0003\u0019a\u0014N\\5u}QQA+\u0016,X1fS6\fX/\u0011\u0005\u0015\u0002\u0001\"B\u000eR\u0001\u0004a\u0002\"B\u0012R\u0001\u0004!\u0003\"B\u0015R\u0001\u0004Q\u0003\"\u0002\u0018R\u0001\u0004y\u0003\"B\u001aR\u0001\u0004!\u0004\"\u0002\u001dR\u0001\u0004I\u0004\"B\u001fR\u0001\u0004q\u0004\"B#R\u0001\u00041\u0005\"B'R\u0001\u0004q\u0005\"B0\u0001\t\u0003\u0001\u0017!E2iK\u000e\\gi\u001c7eKJ,\u00050[:ugR\u0011\u0011\r\u001a\t\u0003\u001b\tL!a\u0019\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Kz\u0003\rAZ\u0001\tM>dG-\u001a:JIB\u0011qM\u001c\b\u0003Q2\u0004\"!\u001b\b\u000e\u0003)T!a\u001b\u0006\u0002\rq\u0012xn\u001c;?\u0013\tig\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u0014aa\u0015;sS:<'BA7\u000fQ\tq&\u000f\u0005\u0002tu6\tAO\u0003\u0002vm\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005]D\u0018aB7fiJL7m\u001d\u0006\u0003s\"\t\u0001bY8eC\"\fG.Z\u0005\u0003wR\u0014Q\u0001V5nK\u0012DQ! \u0001\u0005\u0002y\fa!\u001a=jgR\u001cHcA@\u0002\u0006A\u0019Q\"!\u0001\n\u0007\u0005\raBA\u0004C_>dW-\u00198\t\u000b\u0015d\b\u0019\u00014)\u0005q\u0014\bbBA\u0006\u0001\u0011\u0005\u0011QB\u0001\tO\u0016$H+\u001b;mKR\u0019a-a\u0004\t\r\u0015\fI\u00011\u0001gQ\r\tIA\u001d\u0005\b\u0003+\u0001A\u0011AA\f\u0003!1\u0017N\u001c3Cs&#GCBA\r\u0003S\tY\u0003\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\r\u0019|G\u000eZ3s\u0015\r\t\u0019\u0003B\u0001\u0007I>l\u0017-\u001b8\n\t\u0005\u001d\u0012Q\u0004\u0002\u0007\r>dG-\u001a:\t\r\u0015\f\u0019\u00021\u0001g\u0011)\ti#a\u0005\u0011\u0002\u0003\u0007\u0011qF\u0001\u0006I\u0016\u0004H\u000f\u001b\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0012\u0001\u00026bm\u0006LA!!\u0010\u00024\t9\u0011J\u001c;fO\u0016\u0014\bfAA\ne\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013A\u00034j]\u0012\u0014\u0015\u0010U1uQR1\u0011\u0011DA$\u0003\u0017Bq!!\u0013\u0002B\u0001\u0007a-\u0001\u0003qCRD\u0007BCA\u0017\u0003\u0003\u0002\n\u00111\u0001\u0002NA\u0019Q\"a\u0014\n\u0007\u0005EcBA\u0002J]RD3!!\u0011s\u0011\u001d\t9\u0006\u0001C\u0001\u00033\n1\u0003\\5tiZKWm^1cY\u00164u\u000e\u001c3feN$\u0002\"a\u0017\u0002h\u0005-\u0014Q\u000f\t\u0007\u0003;\n\u0019'!\u0007\u000e\u0005\u0005}#\u0002BA1\u0003o\tA!\u001e;jY&!\u0011QMA0\u0005\u0011a\u0015n\u001d;\t\u000f\u0005%\u0014Q\u000ba\u0001M\u0006A\u0001/\u0019:f]RLE\r\u0003\u0005\u0002n\u0005U\u0003\u0019AA8\u0003\u0011\u0001\u0018mZ3\u0011\u0007u\t\t(C\u0002\u0002ty\u0011A\u0001U1hK\"I\u0011qOA+!\u0003\u0005\ra`\u0001\u0018I\u0016\u001cwN]1uK^KG\u000f\u001b)fe6L7o]5p]ND3!!\u0016s\u0011\u001d\ti\b\u0001C\u0001\u0003\u007f\nA!\\8wKR1\u0011\u0011DAA\u0003\u0007Ca!ZA>\u0001\u00041\u0007bBAC\u0003w\u0002\rAZ\u0001\f]\u0016<\b+\u0019:f]RLE\rK\u0002\u0002|IDq!a#\u0001\t\u0003\ti)\u0001\u0004sK:\fW.\u001a\u000b\u0007\u00033\ty)!%\t\r\u0015\fI\t1\u0001g\u0011\u001d\t\u0019*!#A\u0002\u0019\fqA\\3x\u001d\u0006lW\rK\u0002\u0002\nJDq!!'\u0001\t\u0003\tY*A\btK\u0006\u00148\r\u001b+f[Bd\u0017\r^3t)\u0019\ti*a*\u0002*B1\u0011QLA2\u0003?\u0003B!!)\u0002$6\u0011\u0011\u0011E\u0005\u0005\u0003K\u000b\tCA\u0004SK2,\u0017m]3\t\r\u0015\f9\n1\u0001g\u0011!\ti'a&A\u0002\u0005=\u0004fAALe\"9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0016AD:fCJ\u001c\u0007NU3mK\u0006\u001cXm\u001d\u000b\t\u0003g\u000by,!1\u0002ZB!\u0011QWA^\u001b\t\t9LC\u0002\u0002:\u0012\taa]3be\u000eD\u0017\u0002BA_\u0003o\u00131CU3mK\u0006\u001cXmU3be\u000eD'+Z:vYRDa!ZAW\u0001\u00041\u0007\u0002CAb\u0003[\u0003\r!!2\u0002\u000f\u0019LG\u000e^3sgB!\u0011qYAk\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017!\u00024pe6\u001c(\u0002BAh\u0003#\f!A^\u0019\u000b\u0007\u0005MG!A\u0002ba&LA!a6\u0002J\ny!+\u001a7fCN,7OR5mi\u0016\u00148\u000f\u0003\u0006\u0002n\u00055\u0006\u0013!a\u0001\u0003_B3!!,s\u0011\u001d\ty\u000e\u0001C\u0001\u0003C\fA\"\\8wKR+W\u000e\u001d7bi\u0016$rAZAr\u0003K\fI\u000f\u0003\u0004f\u0003;\u0004\rA\u001a\u0005\b\u0003O\fi\u000e1\u0001g\u0003)!X-\u001c9mCR,\u0017\n\u001a\u0005\n\u0003W\fi\u000e%AA\u0002}\f\u0001c\u001d5pk2$W*\u001a:hKR+\u0017-\\:)\u0007\u0005u'\u000fC\u0004\u0002r\u0002!\t!a=\u0002\r\r\u0014X-\u0019;f)\u0019\tI\"!>\u0002x\"9\u0011\u0011NAx\u0001\u00041\u0007\u0002CA\u0010\u0003_\u0004\r!!\u0007)\u0007\u0005=(\u000fC\u0004\u0002r\u0002!\t!!@\u0015\u0011\u0005e\u0011q B\u0001\u0005\u0007Aq!!\u001b\u0002|\u0002\u0007a\r\u0003\u0005\u0002 \u0005m\b\u0019AA\r\u0011\u001d\u0011)!a?A\u0002}\f!c\u0019:fCR,G)\u001a4bk2$H+Z1ng\"\u001a\u00111 :\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e\u00051A-\u001a7fi\u0016$2!\u0019B\b\u0011\u0019)'\u0011\u0002a\u0001M\"\u001a!\u0011\u0002:\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0018\u0005QQ.\u001a:hKR+\u0017-\\:\u0015\u000f\u0005\u0014IBa\u0007\u0003\u001e!1QMa\u0005A\u0002\u0019Dq!a:\u0003\u0014\u0001\u0007a\r\u0003\u0005\u0003 \tM\u0001\u0019\u0001B\u0011\u00035!X-\u001c9mCR,G+Z1ngB1!1\u0005B\u0017\u0005gqAA!\n\u0003*9\u0019\u0011Na\n\n\u0003=I1Aa\u000b\u000f\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\f\u00032\t\u00191+Z9\u000b\u0007\t-b\u0002\u0005\u0003\u0002\"\nU\u0012\u0002\u0002B\u001c\u0003C\u0011A\u0001V3b[\"9!1\b\u0001\u0005\n\tu\u0012\u0001\u0004:fa2\f7-\u001a+fC6\u001cH#B1\u0003@\t\u0005\u0003BB3\u0003:\u0001\u0007a\rC\u0004\u0002h\ne\u0002\u0019\u00014\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H\u0005YR.\u001a:hKR+W\u000e\u001d7bi\u0016\fe\u000e\u001a$pY\u0012,'\u000fV3b[N$bA!\t\u0003J\t5\u0003\u0002\u0003B&\u0005\u0007\u0002\rA!\t\u0002\u0017\u0019|G\u000eZ3s)\u0016\fWn\u001d\u0005\t\u0005?\u0011\u0019\u00051\u0001\u0003\"!9!\u0011\u000b\u0001\u0005\n\tM\u0013!\u0004:fg\u0016$H+Y:l)\u0016\fW\u000eF\u0002b\u0005+Bq!a:\u0003P\u0001\u0007a\rC\u0004\u0003Z\u0001!IAa\u0017\u0002=\r\u0014X-\u0019;f\t\u00164\u0017-\u001e7u)\u0016\fWn\u001d$peRCWMR8mI\u0016\u0014H#B1\u0003^\t}\u0003\u0002CA\u0010\u0005/\u0002\r!!\u0007\t\u000f\u0005%$q\u000ba\u0001M\"9!1\r\u0001\u0005\n\t\u0015\u0014!F2iK\u000e\\gi\u001c7eKJ\u001c\u0015M\u001c\"f\u001b>4X\r\u001a\u000b\u0006C\n\u001d$\u0011\u000e\u0005\u0007K\n\u0005\u0004\u0019\u00014\t\u000f\t-$\u0011\ra\u0001M\u0006Iq\u000e]3sCRLwN\u001c\u0005\b\u0005_\u0002A\u0011\u0002B9\u0003]\u0019\u0007.Z2l)\u0016l\u0007\u000f\\1uK\u000e\u000bgNQ3N_Z,G\rF\u0002b\u0005gBq!a:\u0003n\u0001\u0007a\rC\u0004\u0003x\u0001!IA!\u001f\u0002%\u001d,GOU;o]&twMU3mK\u0006\u001cXm\u001d\u000b\u0005\u0005w\u0012i\b\u0005\u0004\u0003$\t5\u0012q\u0014\u0005\u0007K\nU\u0004\u0019\u00014\t\u000f\t\u0005\u0005\u0001\"\u0003\u0003\u0004\u0006\u0011r-\u001a;F]\u0006\u0014G.\u001a3Ue&<w-\u001a:t)\u0011\u0011)I!$\u0011\r\t\r\"Q\u0006BD!\u0011\t\tK!#\n\t\t-\u0015\u0011\u0005\u0002\u000f%\u0016dW-Y:f)JLwmZ3s\u0011\u001d\u0011yIa A\u0002\u0019\f!\"\u00198dKN$xN]%e\u0011\u001d\u0011\u0019\n\u0001C\u0005\u0005+\u000b1dZ3u\u0003V$xn\u0015;beR\u0004VM\u001c3j]\u001e\u0014V\r\\3bg\u0016\u001cH\u0003\u0002B>\u0005/Ca!\u001aBI\u0001\u00041\u0007\"\u0003BN\u0001E\u0005I\u0011\u0001BO\u0003YiwN^3UK6\u0004H.\u0019;fI\u0011,g-Y;mi\u0012\u001aTC\u0001BPU\ry(\u0011U\u0016\u0003\u0005G\u0003BA!*\u0003.6\u0011!q\u0015\u0006\u0005\u0005S\u0013Y+A\u0005v]\u000eDWmY6fI*\u0011QOD\u0005\u0005\u0005_\u00139KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba-\u0001#\u0003%\tA!.\u0002%\u0019Lg\u000e\u001a\"z\u0013\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0005oSC!a\f\u0003\"\"I!1\u0018\u0001\u0012\u0002\u0013\u0005!QX\u0001\u0015M&tGMQ=QCRDG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t}&\u0006BA'\u0005CC\u0011Ba1\u0001#\u0003%\tA!(\u0002;1L7\u000f\u001e,jK^\f'\r\\3G_2$WM]:%I\u00164\u0017-\u001e7uIMB\u0011Ba2\u0001#\u0003%\tA!3\u00021M,\u0017M]2i%\u0016dW-Y:fg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003L*\"\u0011q\u000eBQ\u0001")
public class FolderService
implements Logging {
    private final FolderRepository folders;
    private final TeamService teamService;
    private final ReleaseRepository releaseRepository;
    private final TaskService taskService;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private final ReleaseTriggerRepository releaseTriggersRepository;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    @Timed
    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    @Timed
    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Folder ", " cannot be found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.ROOT_FOLDER_ID})), new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find Folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})), new Object[0]);
        });
    }

    @Timed
    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find Folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})), new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Folder findByPath(String path, int depth) {
        void var3_3;
        Folder found = this.folders.findByPath(path, depth);
        this.permissions.check(XLReleasePermissions.VIEW_FOLDER, found.getId());
        return var3_3;
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        this.permissions.checkViewFolder(parentId);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.folders.listViewableFolders(parentId, page, decorateWithPermissions)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkFolderCanBeMoved(folderId, "move");
        return this.folders.move(folderId, newParentId);
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        Checks.checkArgument((!newName.trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        return this.folders.rename(folderId, newName);
    }

    @Timed
    public List<Release> searchTemplates(String folderId, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), page.depth()).getReleases();
    }

    @Timed
    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage(), page.depth());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    @Timed
    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String string;
        String newTemplateId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId, Ids.getName((String)templateId)}));
        this.checkTemplateCanBeMoved(templateId);
        String string2 = Ids.getParentId((String)templateId);
        String string3 = folderId;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to move template ", " to same folder ", ". Will be ignored."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{templateId, folderId})));
            string = templateId;
        } else {
            Buffer templateTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getStoredTeams(templateId)).asScala();
            this.releaseRepository.move(templateId, newTemplateId);
            this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
            if (shouldMergeTeams) {
                this.mergeTeams(folderId, newTemplateId, (Seq<Team>)templateTeams);
            } else {
                this.replaceTeams(folderId, newTemplateId);
            }
            string = newTemplateId;
        }
        return string;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        return this.create(parentId, folder, true);
    }

    @Timed
    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        Folder saved;
        block3: {
            Checks.checkArgument((!folder.getTitle().trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
            this.checkFolderExists(parentId);
            this.folders.checkNameIsUnique(parentId, folder.getTitle());
            if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
                folder.setId(this.ciIdService.getUniqueId(Type.valueOf(Folder.class), parentId));
            } else {
                folder.setId(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentId, Ids.getName((String)folder.getId())})));
            }
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating folder ", " with id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folder.getTitle(), folder.getId()})));
            saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
            if (!createDefaultTeams) break block3;
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.createDefaultTeamsForTheFolder(saved, parentId);
            }
        }
        return saved;
    }

    @Timed
    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, "delete");
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})));
        this.folders.delete(folderId, (Function2<Object, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(uid, id) -> {
            this.releaseRepository.deleteWithUid(id, BoxesRunTime.unboxToInt((Object)uid));
            return BoxedUnit.UNIT;
        });
    }

    private void mergeTeams(String folderId, String templateId, Seq<Team> templateTeams) {
        block0: {
            if (!templateTeams.nonEmpty()) break block0;
            Buffer folderTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(folderId)).asScala();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable & scala.Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> folderId);
            Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teamService.saveTeamsToPlatform(folderTeamsContainerId, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(mergedTeams).asJava());
            this.teamService.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teamService.deleteTeamsFromPlatform(templateId);
    }

    private Seq<Team> mergeTemplateAndFolderTeams(Seq<Team> folderTeams, Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((TraversableOnce)folderTeams.map((Function1 & Serializable & scala.Serializable)team -> new Tuple2((Object)team.getTeamName(), team), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).toSeq());
        templateTeams.foreach((Function1 & Serializable & scala.Serializable)templateTeam -> {
            MapLike mapLike;
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                mapLike = folderTeamsMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                Set memberSet = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getMembers()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getMembers()).asScala()).toSet());
                Set roleSet = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getRoles()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getRoles()).asScala()).toSet());
                Set permissionSet = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getPermissions()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getPermissions()).asScala()).toSet());
                folderTeam.setMembers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(memberSet.toSeq()).asJava());
                folderTeam.setRoles((List)JavaConverters$.MODULE$.seqAsJavaListConverter(roleSet.toSeq()).asJava());
                folderTeam.setPermissions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(permissionSet.toSeq()).asJava());
                mapLike = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return mapLike;
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releaseRepository.findById(templateId, null);
        template.getAllTasks().forEach(task -> $this.taskService.applyNewTeam(null, (Task)task));
    }

    private void createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions(XLReleasePermissions.getFolderPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.setPermissions(XLReleasePermissions.getReleasePermissions());
        releaseAdmin.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        this.teamService.saveTeamsToPlatform(folder.getId(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{folderOwner, templateOwner, releaseAdmin}))).asJava());
    }

    private void checkFolderCanBeMoved(String folderId, String operation) {
        Seq<Release> activeReleases = this.getRunningReleases(folderId);
        Seq<ReleaseTrigger> enabledTriggers = this.getEnabledTriggers(folderId);
        Seq<Release> autoStartPendingReleases = this.getAutoStartPendingReleases(folderId);
        if (activeReleases.nonEmpty() || enabledTriggers.nonEmpty() || autoStartPendingReleases.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to ", " folder ", ", which has active releases ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation, folderId, ((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or enabled triggers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or pending releases with auto start option enabled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
            String details = "";
            if (activeReleases.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Active releases: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            if (enabledTriggers.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Enabled triggers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)t -> t.getTemplate().getTitle() + "/" + t.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            if (autoStartPendingReleases.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Pending releases with auto start: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You cannot ", " this folder. The folder or its subfolders contain active releases or templates ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation, details})), new Object[0]);
        }
    }

    private void checkTemplateCanBeMoved(String templateId) {
        Buffer enabledTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseTriggersRepository.findEnabledReleaseTriggers(templateId)).asScala();
        if (enabledTriggers.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to move template ", " with enabled triggers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{templateId, enabledTriggers})));
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You can't move this template because it has one or more enabled triggers: "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{enabledTriggers.mkString(", ")})), new Object[0]);
        }
    }

    private Seq<Release> getRunningReleases(String folderId) {
        Page x$8 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$9 = ReleaseStatus.ACTIVE_STATUSES;
        Right<String, String> x$10 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$11 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$12 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$13 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$8, (Either<String, String>)x$10, x$9, x$11, x$12, x$13))).asScala();
    }

    private Seq<ReleaseTrigger> getEnabledTriggers(String ancestorId) {
        Page x$14 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(2));
        ReleaseStatus[] x$15 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE});
        Right<String, String> x$16 = ReleaseSearchByParams$.MODULE$.byAncestor(ancestorId);
        String x$17 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$18 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$19 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$14, (Either<String, String>)x$16, x$15, x$17, x$18, x$19))).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$6.getReleaseTriggers()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isEnabled()));
    }

    private Seq<Release> getAutoStartPendingReleases(String folderId) {
        Page x$20 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$21 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED});
        Right<String, String> x$22 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        boolean x$23 = true;
        String x$24 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$25 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$20, (Either<String, String>)x$22, x$21, x$24, x$25, x$23))).asScala();
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public FolderService(FolderRepository folders, TeamService teamService, ReleaseRepository releaseRepository, TaskService taskService, CiIdService ciIdService, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus, ReleaseTriggerRepository releaseTriggersRepository) {
        this.folders = folders;
        this.teamService = teamService;
        this.releaseRepository = releaseRepository;
        this.taskService = taskService;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        this.releaseTriggersRepository = releaseTriggersRepository;
        Logging.$init$((Logging)this);
    }
}

