/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables.reference;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableMappingUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.repository.CiProperty;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class VariableCollectingVisitor
implements ReleaseVisitor {
    public static final String VARIABLE_MAPPING_PROPERTY = "variableMapping";
    private final Map<String, VariableReference> variables = Maps.newTreeMap();

    public static Set<VariableReference> collectFrom(VisitableItem item) {
        VariableCollectingVisitor visitor = new VariableCollectingVisitor();
        item.accept(visitor);
        return visitor.result();
    }

    public Set<VariableReference> result() {
        return Sets.newTreeSet(this.variables.values());
    }

    @Override
    public void visit(ReleaseExtension extension) {
        extension.getVariableUsages().forEach(this::collectVariables);
        this.collectVariablesInVariableMappings(extension);
    }

    @Override
    public void visit(PlanItem item) {
        item.getVariableUsages().forEach(this::collectVariables);
        this.collectVariablesInVariableMappings(item);
    }

    @Override
    public void visit(ValueProviderConfiguration valueProviderConfiguration) {
        this.collectVariablesInVariableMappings(valueProviderConfiguration);
    }

    private void collectVariables(UsagePoint usagePoint) {
        Map<String, VariableReference.VariableUsageType> variablesAtUsagePoint = usagePoint.collectVariables();
        variablesAtUsagePoint.forEach((variableName, variableType) -> {
            VariableReference variableRef = this.variables.getOrDefault(variableName, new VariableReference((String)variableName, (VariableReference.VariableUsageType)((Object)variableType)));
            this.variables.putIfAbsent((String)variableName, variableRef);
            variableRef.addUsagePoint(usagePoint, (VariableReference.VariableUsageType)((Object)variableType));
        });
    }

    private void collectVariablesInVariableMappings(BaseConfigurationItem item) {
        Map variableMapping;
        if (item.hasProperty(VARIABLE_MAPPING_PROPERTY) && (variableMapping = (Map)item.getProperty(VARIABLE_MAPPING_PROPERTY)) != null) {
            variableMapping.forEach((fqPropertyName, variable) -> {
                Optional<CiProperty> ciProperty = CiProperty.of((ConfigurationItem)item, fqPropertyName);
                if (variable != null && ciProperty.isPresent()) {
                    this.collectVariables(new VariableMappingUsagePoint((ConfigurationItem)item, (String)fqPropertyName, ciProperty.get()));
                }
            });
        }
    }
}

