/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jvm;

import com.codahale.metrics.RatioGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FileDescriptorRatioGauge
extends RatioGauge {
    private final OperatingSystemMXBean os;

    public FileDescriptorRatioGauge() {
        this(ManagementFactory.getOperatingSystemMXBean());
    }

    public FileDescriptorRatioGauge(OperatingSystemMXBean os) {
        this.os = os;
    }

    protected RatioGauge.Ratio getRatio() {
        try {
            return RatioGauge.Ratio.of((double)this.invoke("getOpenFileDescriptorCount"), (double)this.invoke("getMaxFileDescriptorCount"));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return RatioGauge.Ratio.of((double)Double.NaN, (double)Double.NaN);
        }
    }

    private long invoke(String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = this.os.getClass().getDeclaredMethod(name, new Class[0]);
        method.setAccessible(true);
        return (Long)method.invoke((Object)this.os, new Object[0]);
    }
}

