/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.apiclient.Asset;
import com.versionone.apiclient.Attribute;
import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.exceptions.V1Exception;
import com.versionone.apiclient.interfaces.IAttributeDefinition;

class SingleValueAttribute
extends Attribute {
    private Object _value;
    private Object _newValue;
    private boolean _hasChanged;

    SingleValueAttribute(IAttributeDefinition def, Asset asset) {
        super(def, asset);
    }

    @Override
    public Object getOriginalValue() {
        return this._value;
    }

    @Override
    public Object getNewValue() {
        return this.hasChanged() ? this._newValue : null;
    }

    @Override
    public Object[] getOriginalValues() {
        return SingleValueAttribute.wrap(this.getOriginalValue());
    }

    @Override
    public Object[] getNewValues() {
        return SingleValueAttribute.wrap(this.getNewValue());
    }

    private static Object[] wrap(Object value) {
        if (value == null) {
            return null;
        }
        return new Object[]{value};
    }

    @Override
    public Object[] getAddedValues() {
        return this.getNewValues();
    }

    @Override
    public Object[] getRemovedValues() {
        if (this.hasChanged()) {
            return this.getOriginalValues();
        }
        return null;
    }

    @Override
    public boolean hasChanged() {
        return this._hasChanged;
    }

    @Override
    void setValue(Object value) throws APIException {
        this.checkReadOnly();
        try {
            value = this.getDefinition().coerce(value);
        }
        catch (V1Exception e) {
            throw new APIException("Error converting data", e);
        }
        this.checkNull(value);
        this._newValue = value;
        this._hasChanged = true;
    }

    @Override
    void forceValue(Object value) throws APIException {
        try {
            value = this.getDefinition().coerce(value);
        }
        catch (V1Exception e) {
            throw new APIException("Error converting data", e);
        }
        this.checkNull(value);
        this._newValue = value;
        this._hasChanged = true;
    }

    @Override
    void addValue(Object value) {
        throw new RuntimeException("Cannot assign multiple values to a single-value attribute: " + this.getDefinition().getToken());
    }

    @Override
    void removeValue(Object value) {
        throw new RuntimeException("Cannot remove values from a single-value attribute: " + this.getDefinition().getToken());
    }

    @Override
    public void acceptChanges() {
        if (this.hasChanged()) {
            this._value = this._newValue;
            this._newValue = null;
            this._hasChanged = false;
        }
    }

    @Override
    public void rejectChanges() {
        this._newValue = null;
        this._hasChanged = false;
    }

    @Override
    void loadValue(Object value) throws APIException {
        if (this._value != null) {
            throw new RuntimeException("Cannot load multiple values into a single-value attribute: " + this.getDefinition().getToken());
        }
        try {
            this._value = this.getDefinition().coerce(value);
        }
        catch (V1Exception e) {
            throw new APIException("Error converting data", e);
        }
    }

    public String toString() {
        StringBuffer rc = new StringBuffer(128);
        rc.append("{value=").append(this._value);
        if (this.hasChanged()) {
            rc.append(", newValue=").append(this._newValue);
        }
        rc.append("}");
        return rc.toString();
    }
}

