/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient.filters;

import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.filters.AndFilterTerm;
import com.versionone.apiclient.filters.FilterTerm;
import com.versionone.apiclient.filters.IFilterTerm;
import com.versionone.apiclient.filters.OrFilterTerm;
import com.versionone.apiclient.interfaces.IAttributeDefinition;
import com.versionone.apiclient.services.TextBuilder;
import java.util.ArrayList;
import java.util.List;

public abstract class GroupFilterTerm
implements IFilterTerm {
    List<IFilterTerm> terms = new ArrayList<IFilterTerm>();

    public boolean hasTerm() {
        return this.terms.size() > 0;
    }

    @Override
    public String getToken() throws APIException {
        return this.makeToken(true);
    }

    @Override
    public String getShortToken() throws APIException {
        return this.makeToken(false);
    }

    private String makeToken(Boolean full) throws APIException {
        ArrayList<String> tokens = new ArrayList<String>();
        for (IFilterTerm term : this.terms) {
            String token = full != false ? term.getToken() : term.getShortToken();
            if (token == null) continue;
            tokens.add(token);
        }
        if (tokens.isEmpty()) {
            return null;
        }
        if (tokens.size() == 1) {
            return (String)tokens.get(0);
        }
        return "(" + TextBuilder.join(tokens.toArray(), this.getTokenSeperator()) + ")";
    }

    abstract String getTokenSeperator();

    protected GroupFilterTerm(IFilterTerm[] terms) {
        for (IFilterTerm term : terms) {
            if (term == null) continue;
            this.terms.add(term);
        }
    }

    public GroupFilterTerm and(IFilterTerm ... terms) {
        AndFilterTerm term = new AndFilterTerm(terms);
        this.terms.add(term);
        return term;
    }

    public GroupFilterTerm or(IFilterTerm ... terms) {
        OrFilterTerm term = new OrFilterTerm(terms);
        this.terms.add(term);
        return term;
    }

    public FilterTerm Term(IAttributeDefinition def) {
        FilterTerm term = new FilterTerm(def);
        this.terms.add(term);
        return term;
    }
}

