/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.bdio.model.externalid;

import com.synopsys.integration.bdio.model.BdioId;
import com.synopsys.integration.bdio.model.Forge;
import com.synopsys.integration.util.Stringable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ExternalId
extends Stringable {
    public static final Comparator<ExternalId> ARE_SAME = Comparator.comparing(ExternalId::createExternalId);
    private static final int NAME_POSITION = 0;
    private static final int VERSION_POSITION = 1;
    private final Forge forge;
    private List<String> pieces = new ArrayList<String>();
    private String prefix;
    private String suffix;

    public static ExternalId createFromExternalId(Forge forge, String fullExternalId, String name, String version) {
        List<String> unknownPieces = Arrays.stream(StringUtils.split((String)fullExternalId, (String)forge.getSeparator())).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        ExternalId externalId = new ExternalId(forge);
        if (unknownPieces.isEmpty()) {
            return externalId;
        }
        if (unknownPieces.size() == 1) {
            String firstPiece = (String)unknownPieces.get(0);
            if (firstPiece.equals(name)) {
                externalId.setName(firstPiece);
            } else {
                externalId.setPath(firstPiece);
            }
            return externalId;
        }
        if (!unknownPieces.contains(name)) {
            externalId.setModuleNames(unknownPieces.toArray(new String[0]));
            return externalId;
        }
        int indexToConsider = 0;
        if (((String)unknownPieces.get(indexToConsider)).equals(name)) {
            externalId.setName(name);
            ++indexToConsider;
        } else {
            externalId.prefix = (String)unknownPieces.get(indexToConsider++);
            externalId.setName(unknownPieces.get(indexToConsider++));
        }
        indexToConsider = ExternalId.considerVersion(version, externalId, unknownPieces, indexToConsider);
        if (unknownPieces.size() >= indexToConsider + 1) {
            externalId.suffix = unknownPieces.get(indexToConsider++);
        }
        if (unknownPieces.size() >= indexToConsider + 1) {
            externalId.setModuleNames(unknownPieces.toArray(new String[0]));
        }
        return externalId;
    }

    private static int considerVersion(String version, ExternalId externalId, List<String> unknownPieces, int indexToConsider) {
        if (unknownPieces.size() >= indexToConsider + 1 && unknownPieces.get(indexToConsider).equals(version)) {
            externalId.setVersion(version);
            ++indexToConsider;
        }
        return indexToConsider;
    }

    public ExternalId(Forge forge) {
        this.forge = forge;
        this.pieces.add(0, null);
        this.pieces.add(1, null);
    }

    public String[] getExternalIdPieces() {
        ArrayList<String> externalIdPieces = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.prefix)) {
            externalIdPieces.add(this.prefix);
        }
        this.pieces.stream().filter(StringUtils::isNotBlank).forEach(externalIdPieces::add);
        if (StringUtils.isNotBlank((CharSequence)this.suffix)) {
            externalIdPieces.add(this.suffix);
        }
        return externalIdPieces.toArray(new String[0]);
    }

    public BdioId createBdioId() {
        ArrayList<String> bdioIdPieces = new ArrayList<String>();
        bdioIdPieces.add(this.forge.toString());
        bdioIdPieces.addAll(Arrays.asList(this.getExternalIdPieces()));
        return BdioId.createFromPieces(bdioIdPieces);
    }

    public String createExternalId() {
        return StringUtils.join((Object[])this.getExternalIdPieces(), (String)this.forge.getSeparator());
    }

    public Forge getForge() {
        return this.forge;
    }

    public String getLayer() {
        return this.getPrefix();
    }

    public void setLayer(String layer) {
        this.prefix = layer;
    }

    public String getGroup() {
        return this.getPrefix();
    }

    public void setGroup(String group) {
        this.prefix = group;
    }

    public String getName() {
        return this.pieces.get(0);
    }

    public void setName(String name) {
        this.pieces.set(0, name);
    }

    public String getVersion() {
        return this.pieces.get(1);
    }

    public void setVersion(String version) {
        this.pieces.set(1, version);
    }

    public String getArchitecture() {
        return this.getSuffix();
    }

    public void setArchitecture(String architecture) {
        this.suffix = architecture;
    }

    public String[] getModuleNames() {
        return this.pieces.toArray(new String[0]);
    }

    public void setModuleNames(String[] moduleNames) {
        this.prefix = null;
        this.suffix = null;
        this.pieces.set(0, null);
        this.pieces.set(1, null);
        Arrays.stream(moduleNames).filter(StringUtils::isNotBlank).forEach(this.pieces::add);
    }

    public String getPath() {
        return this.pieces.get(0);
    }

    public void setPath(String path) {
        this.prefix = null;
        this.suffix = null;
        this.pieces.set(0, path);
        this.pieces.set(1, null);
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected String getSuffix() {
        return this.suffix;
    }
}

