/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.http.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.flipkart.zjsonpatch.JsonDiff;
import com.flipkart.zjsonpatch.JsonPatch;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.synopsys.integration.blackduck.api.core.BlackDuckResponse;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.blackduck.http.BlackDuckPageResponse;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.response.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class BlackDuckJsonTransformer {
    private final Gson gson;
    private final ObjectMapper objectMapper;
    private final IntLogger logger;

    public BlackDuckJsonTransformer(Gson gson, ObjectMapper objectMapper, IntLogger logger) {
        this.gson = gson;
        this.objectMapper = objectMapper;
        this.logger = logger;
    }

    public <T extends BlackDuckResponse> T getResponse(Response response, Class<T> clazz) throws IntegrationException {
        String json = response.getContentString();
        return this.getResponseAs(json, clazz);
    }

    public <T extends BlackDuckResponse> T getResponseAs(String json, Class<T> clazz) throws BlackDuckIntegrationException {
        try {
            JsonElement jsonElement = this.gson.fromJson(json, JsonElement.class);
            return this.getResponseAs(jsonElement, clazz);
        }
        catch (JsonSyntaxException e) {
            this.logger.error(String.format("Could not parse the provided json with Gson:%s%s", System.lineSeparator(), json));
            throw new BlackDuckIntegrationException(e.getMessage(), e);
        }
    }

    public <T extends BlackDuckResponse> T getResponseAs(JsonElement jsonElement, Class<T> clazz) throws BlackDuckIntegrationException {
        String json = this.gson.toJson(jsonElement);
        try {
            BlackDuckResponse blackDuckResponse = (BlackDuckResponse)this.gson.fromJson(jsonElement, clazz);
            if (blackDuckResponse.hasSubclasses()) {
                BlackDuckResponse subclassResponse;
                Class<? extends BlackDuckResponse> subclass = blackDuckResponse.getSubclass();
                blackDuckResponse = subclassResponse = this.gson.fromJson(jsonElement, subclass);
            }
            blackDuckResponse.setGson(this.gson);
            blackDuckResponse.setJsonElement(jsonElement);
            blackDuckResponse.setJson(json);
            this.setPatch(blackDuckResponse);
            return (T)blackDuckResponse;
        }
        catch (JsonSyntaxException e) {
            this.logger.error(String.format("Could not parse the provided jsonElement with Gson:%s%s", System.lineSeparator(), json));
            throw new BlackDuckIntegrationException(e.getMessage(), e);
        }
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getResponses(String json, Class<T> clazz) throws IntegrationException {
        try {
            JsonObject jsonObject = this.gson.fromJson(json, JsonObject.class);
            int totalCount = jsonObject.get("totalCount").getAsInt();
            JsonArray items = jsonObject.get("items").getAsJsonArray();
            ArrayList<T> itemList = new ArrayList<T>();
            for (JsonElement jsonElement : items) {
                itemList.add(this.getResponseAs(jsonElement, clazz));
            }
            return new BlackDuckPageResponse(totalCount, itemList);
        }
        catch (JsonSyntaxException e) {
            this.logger.error(String.format("Could not parse the provided json responses with Gson:%s%s", System.lineSeparator(), json));
            throw new BlackDuckIntegrationException(e.getMessage(), e);
        }
    }

    public String producePatchedJson(BlackDuckResponse blackDuckResponse) {
        String lossyJson = this.gson.toJson(blackDuckResponse);
        try {
            JsonNode target = this.objectMapper.readTree(lossyJson);
            JsonNode patch = blackDuckResponse.getPatch();
            List<JsonNode> listOfPatches = this.transformPatchToListOfPatches(patch);
            for (JsonNode singleChangePatch : listOfPatches) {
                try {
                    target = JsonPatch.apply(singleChangePatch, target);
                }
                catch (Exception e) {
                    this.logger.warn("Could not apply a particular change - this may not be an issue if change involves an object that wasn't being updated: " + e.getMessage());
                }
            }
            StringWriter stringWriter = new StringWriter();
            this.objectMapper.writeValue((Writer)stringWriter, (Object)target);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<JsonNode> transformPatchToListOfPatches(JsonNode patch) {
        ArrayList<JsonNode> listOfPatches = new ArrayList<JsonNode>();
        for (JsonNode change : patch) {
            ArrayNode changeArray = JsonNodeFactory.instance.arrayNode(1);
            changeArray.add(change);
            listOfPatches.add((JsonNode)changeArray);
        }
        return listOfPatches;
    }

    private void setPatch(BlackDuckResponse blackDuckResponse) {
        String lossyJson = this.gson.toJson(blackDuckResponse);
        try {
            JsonNode source = this.objectMapper.readTree(lossyJson);
            JsonNode target = this.objectMapper.readTree(blackDuckResponse.getJson());
            JsonNode patch = JsonDiff.asJson(source, target);
            blackDuckResponse.setPatch(patch);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

