/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.view.ReleaseTriggerOverview;
import com.xebialabs.xlrelease.views.BulkActionResultView;
import java.util.List;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;

@Path(value="/api/v1/triggers")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@PublicApi
@ShowOnlyPublicApiMembers
public interface TriggersApi
extends ApiService {
    @Override
    default public String serviceName() {
        return "triggersApi";
    }

    @GET
    public Page<ReleaseTriggerOverview> searchTriggers(@BeanParam TriggerFilters var1, @DefaultValue(value="0") @QueryParam(value="page") int var2, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int var3, @Context UriInfo var4);

    @PublicApiMember
    public List<ReleaseTriggerOverview> searchTriggers(TriggerFilters var1, int var2, int var3, Sort var4);

    @PublicApiMember
    public List<ReleaseTriggerOverview> searchTriggers(TriggerFilters var1, int var2, int var3);

    @PUT
    @Path(value="/{triggerId:.*/Trigger[^/]*}/enable")
    @PublicApiMember
    public void enableTrigger(@PathParam(value="triggerId") String var1);

    @POST
    @Path(value="enable")
    @PublicApiMember
    public BulkActionResultView enableTriggers(List<String> var1);

    @POST
    @Path(value="enable/all")
    @PublicApiMember
    public BulkActionResultView enableAllTriggers();

    @PUT
    @Path(value="/{triggerId:.*/Trigger[^/]*}/disable")
    @PublicApiMember
    public void disableTrigger(@PathParam(value="triggerId") String var1);

    @POST
    @Path(value="disable")
    @PublicApiMember
    public BulkActionResultView disableTriggers(List<String> var1);

    @POST
    @Path(value="disable/all")
    @PublicApiMember
    public BulkActionResultView disableAllTriggers();

    @DELETE
    @Path(value="{triggerId:.*/Trigger[^/]*}")
    @PublicApiMember
    public void removeTrigger(@PathParam(value="triggerId") String var1);

    @POST
    @Path(value="{triggerId:.*/Trigger[^/]*}/run")
    public void runTrigger(@PathParam(value="triggerId") String var1);

    @GET
    @PublicApiMember
    @Path(value="types")
    public List<Descriptor> getTypes();

    @POST
    @PublicApiMember
    public Trigger addTrigger(Trigger var1);

    @GET
    @PublicApiMember
    @Path(value="{triggerId:.*Trigger[^/-]*}")
    public Trigger getTrigger(@PathParam(value="triggerId") String var1);

    @PUT
    @PublicApiMember
    @Path(value="{triggerId:.*Trigger[^/-]*}")
    public Trigger updateTrigger(@PathParam(value="triggerId") String var1, Trigger var2);
}

