/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.api.v1.EnvironmentStageApi;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentStageFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentStageForm;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentStageView;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.environments.service.EnvironmentSecurity;
import com.xebialabs.xlrelease.environments.service.EnvironmentStageService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EnvironmentStageApiImpl
implements EnvironmentStageApi {
    private EnvironmentStageService environmentStageService;
    private EnvironmentSecurity environmentSecurity;

    @Autowired
    public EnvironmentStageApiImpl(EnvironmentStageService environmentStageService, EnvironmentSecurity environmentSecurity) {
        this.environmentStageService = environmentStageService;
        this.environmentSecurity = environmentSecurity;
    }

    @Timed
    public EnvironmentStageView createStage(EnvironmentStageForm stageForm) {
        this.environmentSecurity.checkCreate();
        return EnvironmentStageView.fromEnvironmentStage((EnvironmentStage)this.environmentStageService.createStage(stageForm.toStage()));
    }

    @Timed
    public EnvironmentStageView getStageById(String environmentStageId) {
        this.environmentSecurity.checkView();
        return EnvironmentStageView.fromEnvironmentStage((EnvironmentStage)this.environmentStageService.findStageById(environmentStageId));
    }

    @Timed
    public EnvironmentStageView updateStage(String environmentStageId, EnvironmentStageForm stageForm) {
        this.environmentSecurity.checkEdit();
        EnvironmentStage stage = stageForm.toStage();
        stage.setId(environmentStageId);
        return EnvironmentStageView.fromEnvironmentStage((EnvironmentStage)this.environmentStageService.updateStage(stage));
    }

    @Timed
    public List<EnvironmentStageView> searchStages(EnvironmentStageFilters filters) {
        this.environmentSecurity.checkView();
        return this.environmentStageService.searchStages(filters).stream().map(EnvironmentStageView::fromEnvironmentStage).collect(Collectors.toList());
    }

    @Timed
    public void delete(String environmentStageId) {
        this.environmentSecurity.checkEdit();
        this.environmentStageService.deleteStage(environmentStageId);
    }

    @Timed
    public EnvironmentStage create(EnvironmentStage environmentStage) {
        this.environmentSecurity.checkCreate();
        return this.environmentStageService.createStage(environmentStage);
    }

    @Timed
    public EnvironmentStage getById(String environmentStageId) {
        this.environmentSecurity.checkView();
        return this.environmentStageService.findStageById(environmentStageId);
    }

    @Timed
    public EnvironmentStage update(EnvironmentStage environmentCategory) {
        this.environmentSecurity.checkEdit();
        return this.environmentStageService.updateStage(environmentCategory);
    }

    @Timed
    public List<EnvironmentStage> search(EnvironmentStageFilters filters) {
        this.environmentSecurity.checkView();
        return this.environmentStageService.searchStages(filters);
    }
}

