/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import com.xebialabs.xlrelease.repository.ReleaseGroupRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseGroupService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/fixtures/release-groups")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@NoCache
public class FixturesReleaseGroupResource {
    private static final Logger logger = LoggerFactory.getLogger(FixturesReleaseGroupResource.class);
    private ReleaseGroupService releaseGroupService;
    private PermissionChecker permissions;
    private ReleaseGroupRepository releaseGroupRepository;

    @Autowired
    public FixturesReleaseGroupResource(ReleaseGroupService releaseGroupService, PermissionChecker permissions, ReleaseGroupRepository releaseGroupRepository) {
        this.releaseGroupService = releaseGroupService;
        this.permissions = permissions;
        this.releaseGroupRepository = releaseGroupRepository;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    public ReleaseGroup createReleaseGroup(ReleaseGroup releaseGroup) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("creating release group", (Object)releaseGroup.getId());
        return this.releaseGroupService.createGroup(releaseGroup);
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @DELETE
    @Path(value="/{groupId:.*ReleaseGroup[^/]*}")
    public void deleteReleaseGroup(@PathParam(value="groupId") String groupId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("removing release group %s", (Object)groupId);
        if (this.releaseGroupRepository.exists(groupId)) {
            this.releaseGroupRepository.delete(groupId);
        }
    }
}

