/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.IgnoreUrlFilter;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XLRequestLogImpl;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.ReleaseJettyServletWebServerFactory$;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.SessionTrackingMode;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Uu!B\u0012%\u0011\u0003yc!B\u0019%\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%I\u0001\u0010\u0005\u0007\u000b\u0006\u0001\u000b\u0011B\u001f\t\u000f\u0019\u000b!\u0019!C\u0005y!1q)\u0001Q\u0001\nuBq\u0001S\u0001C\u0002\u0013%A\b\u0003\u0004J\u0003\u0001\u0006I!\u0010\u0005\b\u0015\u0006\u0011\r\u0011\"\u0003=\u0011\u0019Y\u0015\u0001)A\u0005{\u0019!\u0011\u0007\n\u0001M\u0011!a6B!b\u0001\n\u0003i\u0006\u0002\u00033\f\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\u0015\\!Q1A\u0005\u0002\u0019D\u0001\"\\\u0006\u0003\u0002\u0003\u0006Ia\u001a\u0005\u0006s-!\tA\u001c\u0005\u0006e.!\te\u001d\u0005\u0006o.!\t\u0006\u001f\u0005\b\u0003\u001fYA\u0011BA\t\u0011\u001d\t)b\u0003C\u0005\u0003/Aq!a\u0007\f\t\u0013\ti\u0002C\u0004\u0002\"-!I!a\t\t\u000f\u0005\u001d2\u0002\"\u0003\u0002*!9\u0011QF\u0006\u0005\n\u0005=\u0002bBA\u001a\u0017\u0011%\u0011Q\u0007\u0005\b\u0003sYA\u0011BA\u001e\u0011\u001d\tyd\u0003C\u0005\u0003\u0003Bq!!\u0012\f\t\u0013\t9\u0005C\u0004\u0002L-!I!!\u0014\t\u000f\u0005E3\u0002\"\u0003\u0002T!9\u0011qK\u0006\u0005\n\u0005e\u0003bBA/\u0017\u0011%\u0011q\f\u0005\b\u0003_ZA\u0011BA9\u0011\u001d\t)h\u0003C\u0005\u0003o\n1EU3mK\u0006\u001cXMS3uif\u001cVM\u001d<mKR<VMY*feZ,'OR1di>\u0014\u0018P\u0003\u0002&M\u0005)!.\u001a;us*\u0011q\u0005K\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005%R\u0013!\u0003=me\u0016dW-Y:f\u0015\tYC&A\u0005yK\nL\u0017\r\\1cg*\tQ&A\u0002d_6\u001c\u0001\u0001\u0005\u00021\u00035\tAEA\u0012SK2,\u0017m]3KKR$\u0018pU3sm2,GoV3c'\u0016\u0014h/\u001a:GC\u000e$xN]=\u0014\u0005\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002_\u0005\t2*R-T)>\u0013Vi\u0018)S\u001fB+%\u000bV-\u0016\u0003u\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\t1\fgn\u001a\u0006\u0002\u0005\u0006!!.\u0019<b\u0013\t!uH\u0001\u0004TiJLgnZ\u0001\u0013\u0017\u0016K6\u000bV(S\u000b~\u0003&k\u0014)F%RK\u0006%\u0001\u000eL\u000bf\u001bFk\u0014*F?B\u000b5kU,P%\u0012{\u0006KU(Q\u000bJ#\u0016,A\u000eL\u000bf\u001bFk\u0014*F?B\u000b5kU,P%\u0012{\u0006KU(Q\u000bJ#\u0016\fI\u0001\u0014)J+6\u000bV*U\u001fJ+u\f\u0015*P!\u0016\u0013F+W\u0001\u0015)J+6\u000bV*U\u001fJ+u\f\u0015*P!\u0016\u0013F+\u0017\u0011\u00029Q\u0013Vk\u0015+T)>\u0013Vi\u0018)B'N;vJ\u0015#`!J{\u0005+\u0012*U3\u0006iBKU+T)N#vJU#`!\u0006\u001b6kV(S\t~\u0003&k\u0014)F%RK\u0006e\u0005\u0002\f\u001bB\u0011aJW\u0007\u0002\u001f*\u0011Q\u0005\u0015\u0006\u0003#J\u000b\u0001\"Z7cK\u0012$W\r\u001a\u0006\u0003'R\u000b1a^3c\u0015\t)f+\u0001\u0003c_>$(BA,Y\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A-\u0002\u0007=\u0014x-\u0003\u0002\\\u001f\na\"*\u001a;usN+'O\u001e7fi^+'mU3sm\u0016\u0014h)Y2u_JL\u0018aE:feZ,'oQ8oM&<WO]1uS>tW#\u00010\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005T\u0013\u0001\u00033fa2|\u00170\u001b;\n\u0005\r\u0004'aE*feZ,'oQ8oM&<WO]1uS>t\u0017\u0001F:feZ,'oQ8oM&<WO]1uS>t\u0007%A\u0005yYJ\u001cuN\u001c4jOV\tq\r\u0005\u0002iW6\t\u0011N\u0003\u0002kQ\u000511m\u001c8gS\u001eL!\u0001\\5\u0003\u0013ac'oQ8oM&<\u0017A\u0003=me\u000e{gNZ5hAQ\u0019q\u000e]9\u0011\u0005AZ\u0001\"\u0002/\u0011\u0001\u0004q\u0006\"B3\u0011\u0001\u00049\u0017\u0001G5t%\u0016<\u0017n\u001d;fe\u0012+g-Y;miN+'O\u001e7fiR\tA\u000f\u0005\u00025k&\u0011a/\u000e\u0002\b\u0005>|G.Z1o\u0003a\u0001xn\u001d;Qe>\u001cWm]:XK\n\f\u0005\u000f]\"p]R,\u0007\u0010\u001e\u000b\u0003sr\u0004\"\u0001\u000e>\n\u0005m,$\u0001B+oSRDQ! \nA\u0002y\f1bY8oi\u0016DHOU8piB\u0019q0a\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\taa^3cCB\u0004(bA\u0013\u0002\b)\u0019\u0011\u0011\u0002-\u0002\u000f\u0015\u001cG.\u001b9tK&!\u0011QBA\u0001\u000559VMY!qa\u000e{g\u000e^3yi\u0006Q1/\u001a;va*+G\u000f^=\u0015\u0007e\f\u0019\u0002C\u0003~'\u0001\u0007a0\u0001\ntKR,\b\u000fT8hE\u0006\u001c7NR5mi\u0016\u0014HcA=\u0002\u001a!)Q\u0010\u0006a\u0001}\u0006Y1/\u001a;vaN\u0003(/\u001b8h)\rI\u0018q\u0004\u0005\u0006{V\u0001\rA`\u0001\u000fg\u0016$X\u000f]!dG\u0016\u001c8\u000fT8h)\rI\u0018Q\u0005\u0005\u0006{Z\u0001\rA`\u0001\u0010g\u0016$X\u000f]\"peN4\u0015\u000e\u001c;feR\u0019\u00110a\u000b\t\u000bu<\u0002\u0019\u0001@\u0002;M,G/\u001e9YgN\u001cVmY;sSRL\b*Z1eKJ\u001ch)\u001b7uKJ$2!_A\u0019\u0011\u0015i\b\u00041\u0001\u007f\u00039\u0019X\r^;q+Jdg)\u001b7uKJ$2!_A\u001c\u0011\u0015i\u0018\u00041\u0001\u007f\u0003M\u0019X\r^;q'2|w\u000fZ8x]\u001aKG\u000e^3s)\rI\u0018Q\b\u0005\u0006{j\u0001\rA`\u0001\u0012g\u0016$X\u000f]#yi\u0016t7/[8o\u0003BLGcA=\u0002D!)Qp\u0007a\u0001}\u0006!2/\u001a;vaZ+'o]5p]\u0016sgm\u001c:dKJ$2!_A%\u0011\u0015iH\u00041\u0001\u007f\u0003E\u0019X\r^;q%\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\u000b\u0004s\u0006=\u0003\"B?\u001e\u0001\u0004q\u0018\u0001F3oC\ndWMU3t_V\u00148-Z:DC\u000eDW\rF\u0002z\u0003+BQ! \u0010A\u0002y\f\u0011#\u001a8bE2,wI_5q\u0011\u0006tG\r\\3s)\rI\u00181\f\u0005\u0006{~\u0001\rA`\u0001\u0012]\u0016<8+Z:tS>t\u0007*\u00198eY\u0016\u0014XCAA1!\u0011\t\u0019'a\u001b\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nqa]3tg&|gNC\u0002(\u0003\u000bIA!!\u001c\u0002f\tq1+Z:tS>t\u0007*\u00198eY\u0016\u0014\u0018!G3oC\ndW-\u00138tiJ,X.\u001a8uK\u0012D\u0015M\u001c3mKJ$2!_A:\u0011\u0015i\u0018\u00051\u0001\u007f\u0003E\u0019X\r\u001e)s_B,'\u000f^=JM:+H\u000e\u001c\u000b\u0006s\u0006e\u0014\u0011\u0013\u0005\b\u0003w\u0012\u0003\u0019AA?\u0003\rYW-\u001f\t\u0005\u0003\u007f\niI\u0004\u0003\u0002\u0002\u0006%\u0005cAABk5\u0011\u0011Q\u0011\u0006\u0004\u0003\u000fs\u0013A\u0002\u001fs_>$h(C\u0002\u0002\fV\na\u0001\u0015:fI\u00164\u0017b\u0001#\u0002\u0010*\u0019\u00111R\u001b\t\u000f\u0005M%\u00051\u0001\u0002~\u0005)a/\u00197vK\u0002")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupAccessLog(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupUrlFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        block2: {
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.setShowStacks(false);
            errorHandler.setShowServlet(false);
            contextRoot.setSessionHandler(this.newSessionHandler());
            contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
            contextRoot.setErrorHandler(errorHandler);
            if (this.xlrConfig().metrics().enabled()) {
                this.enableInstrumentedHandler(contextRoot);
            }
            if (this.xlrConfig().server_http_gzip_enabled()) {
                this.enableGzipHandler(contextRoot);
            }
            if (!this.xlrConfig().server_http_cache_enabled() || !Environment.isProduction()) break block2;
            this.enableResourcesCache(contextRoot);
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSpring(WebAppContext contextRoot) {
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
        this.setPropertyIfNull(ReleaseJettyServletWebServerFactory$.MODULE$.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
        contextRoot.setInitParameter("contextClass", XmlWebApplicationContext.class.getName());
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
        encodingFilter.setName("encodingFilter");
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.setResourceBase(".");
        if (!this.xlrConfig().server_session_storage_enabled()) {
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
        }
        contextRoot.getInitParams().put("resteasy.scan.resources", "true");
        contextRoot.getInitParams().put("resteasy.scan.providers", "true");
        contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
    }

    private void setupAccessLog(WebAppContext contextRoot) {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        XLRequestLogImpl requestLogger = new XLRequestLogImpl("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        contextRoot.insertHandler((HandlerWrapper)requestLogHandler);
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        block0: {
            if (!this.xlrConfig().api_corsEnabled()) break block0;
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "3600");
            holder.setInitParameter("Access-Control-Max-Age", "x-requested-with, accept, origin, content-type");
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupUrlFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new IgnoreUrlFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        block0: {
            long slowDownInMs;
            if (!Environment.isDevelopment() || (slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis()) <= 0L) break block0;
            this.logger.warn((Object)new StringBuilder(48).append("Configuring slow down filter with ").append(slowDownInMs).append(" milliseconds.").toString());
            FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
            slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
            contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(AkkaStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        block0: {
            if (Environment.isDevelopment()) break block0;
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setCompressionLevel(this.xlrConfig().server_http_gzip_compression());
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        contextRoot.insertHandler((HandlerWrapper)gzipHandler);
    }

    /*
     * WARNING - void declaration
     */
    private SessionHandler newSessionHandler() {
        void var1_1;
        block0: {
            SessionHandler sessionHandler = new SessionHandler();
            sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
            sessionHandler.setHttpOnly(true);
            if (this.serverConfiguration().isSsl()) break block0;
            this.logger.debug((Object)new StringBuilder(38).append("Setting up Secure Cookie Enabled to - ").append(this.serverConfiguration().isSecureCookieEnabled()).toString());
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        return var1_1;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        InstrumentedHandler handler = new InstrumentedHandler(XlrMetricRegistry$.MODULE$.metricRegistry());
        contextRoot.insertHandler((HandlerWrapper)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        block1: {
            block2: {
                if (value == null) break block1;
                if (System.getProperty(key) != null) break block2;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)new StringBuilder(26).append("Setting system property - ").append(key).toString());
                }
                System.setProperty(key, value);
                break block1;
            }
            if (!this.logger.isDebugEnabled()) break block1;
            this.logger.debug((Object)new StringBuilder(51).append("Not overriding already specified system property - ").append(key).toString());
        }
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
    }
}

