#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from dockerCompose.api_client import APIClient

if not task.pythonScript.getProperty('yaml')  and not task.pythonScript.getProperty('url'):
    raise Exception('No source for yaml (inline|URL) is provided.')
elif task.pythonScript.getProperty('yaml')  and task.pythonScript.getProperty('url'):
    raise Exception('Please provide only one source for yaml (inline|URL).')

host = task.pythonScript.getProperty("host")
client = APIClient(host, task.pythonScript.getProperty('dockerComposePath'), task.pythonScript.getProperty('cmdParams') if task.pythonScript.hasProperty('cmdParams') else None, task.pythonScript.getProperty('projectName'))
yaml = task.pythonScript.getProperty('yaml')

if not yaml:
    yaml = client.download_file(task.pythonScript.getProperty('url'),task.pythonScript.getProperty('username'),task.pythonScript.getProperty('password'))

response = client.execute_dockercompose(yaml, task.pythonScript.getProperty('command'))

output = response.stdout
error = response.stderr
