#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import java
import yaml

from fortify import FortifyService

FORTIFY_SECURITY_RATING = 'FortifySecurityRating'


def convert_to_datetime(from_date):
    sdf = java.text.SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    return sdf.parse(from_date)


def add_code_compliance_record(outcome=None, compliance_data=None, analysis_date_str=None, project_url=None):
    try:
        analysis_date = convert_to_datetime(analysis_date_str)
        record = taskReportingApi.newCodeComplianceRecord()
        record.targetId = task.id
        record.serverUrl = fortifyServer['url']
        record.serverUser = fortifyServer['username']
        record.project = projectName
        record.outcome = outcome
        record.complianceData = yaml.dump(compliance_data, default_flow_style=False)
        record.analysisDate = analysis_date
        record.project_url = project_url
        taskReportingApi.addRecord(record, True)
    except:
        exctype, value = sys.exc_info()[:2]
        print("{} occurred while creating `udm.CodeComplianceRecord` - {}".format(exctype, value))


if not fortifyServer:
    add_code_compliance_record()
    raise Exception("Fortify server ID must be provided")

project_versions = FortifyService.get_project_versions(fortifyServer, project_name=projectName)

project = None
for project_version in project_versions.get('data'):
    if project_version.get('name') == projectVersion:
        project = project_version
        break

if project is None:
    add_code_compliance_record()
    raise Exception("Project with name '{}' and version '{}' not found".format(projectName, projectVersion))

rating = FortifyService.get_fortify_performance_indicator_histories(fortifyServer, version_id=project.get('id'),
                                                                    indicator=FORTIFY_SECURITY_RATING)

scan_failed = rating['value'] < minimumStarRating

compliance_data = {"Fortify Security Rating": rating['value']}

metrics = {"Total Issues": None, "Critical Issues": "critical", "High Issues": "high", "Medium Issues": "medium",
           "Low Issues": "low"}

for key, value in metrics.iteritems():
    compliance_data[str(key)] = FortifyService.get_issues_count(fortify_server=fortifyServer,
                                                               version_id=project.get('id'),
                                                               issue_type=value)

add_code_compliance_record(outcome=("FAILED" if scan_failed else "PASSED"),
                          analysis_date_str=rating.get('timestamp'),
                          compliance_data=compliance_data,
                          project_url='{}/html/ssc/version/{}/overview'.format(fortifyServer.get('url').strip('/'),
                                                                              project.get('id')))

print "Analysis Date and Time: {}".format(rating['timestamp'])
FortifyService.add_comment("Fortify Security Rating : {}".format(rating['value']))
FortifyService.add_comment("Minimum Security Rating: {}".format(minimumStarRating))
if scan_failed:
    raise Exception("Code compliance check(s) failed")

print "Code compliance checks verified."
