#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from ansible.api_client import APIClient

APIClient.validate_input(task)

host = task.pythonScript.getProperty("host")
client = APIClient(host,task.pythonScript.getProperty('ansibleCmd'),task.pythonScript.getProperty('cmdParams'))
record = taskReportingApi.newDeploymentRecord()
record.targetId = task.id
record.serverUrl = host.getProperty('address')
record.serverUser = host.getProperty('username')
record.deploymentTask_url = "None"

if task.pythonScript.getProperty('playbookPath'):
    playbookPath = task.pythonScript.getProperty('playbookPath')
    response = client.execute_local_playbook(playbookPath)
    if len(playbookPath) > 250:
        record.deploymentTask = playbookPath[:240] + "-TRUNCATED"
    else:
        record.deploymentTask = playbookPath
elif task.pythonScript.getProperty('playbookUrl'):
    playbookUrl = task.pythonScript.getProperty('playbookUrl')
    playbook = APIClient.download_file(playbookUrl,task.pythonScript.getProperty('username'),task.pythonScript.getProperty('password'))
    response = client.execute_playbook(playbook)
    record.deploymentTask_url = playbookUrl
    if len(playbookUrl) > 250:
        record.deploymentTask = playbookUrl[:240] + "-TRUNCATED"
    else:
        record.deploymentTask = playbookUrl
else:
    playbook = task.pythonScript.getProperty('playbook')
    response = client.execute_playbook(playbook)
    if len(playbook) > 250:
        record.deploymentTask = playbook[:240] + "-TRUNCATED"
    else:
        record.deploymentTask = playbook

record.status = 'completed'
taskReportingApi.addRecord(record, True)
output = response.stdout
error = response.stderr

