#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
from opsgenie.OpsgenieClient import OpsgenieClient
import com.xhaus.jyson.JysonCodec as json

client = OpsgenieClient(opsGenieConfig, opsGenieConfig['apiKey'])

teamsList = []
for team in teams:
    teamsList.append({"name": team, "type": "team"})
actionList = []
for action in actions:
    actionList.append(action)
tagList = []
for tag in tags:
    tagList.append(tag)
recipientList = []
for key, val in recipients.items():
    recipientList.append({"name": key.strip(), "type": val.strip()})

body = {
    "message": message,
    "alias": alias,
    "description": description,
    "responders": teamsList,
    "visibleTo": recipientList,
    "actions": actionList,
    "tags": tagList,
    "entity": entity,
    "source": source,
    "priority": priority,
    "user": user,
    "note": note
}

# for k,v in body.items():
#     if v is None:
#         body.pop(k)

jsonBody = json.dumps(body)
data, status = client.createAlert('alerts', jsonBody)
requestId = data['requestId']
reqData = client.httpGetUrl("alerts/requests/" + requestId)
if reqData['data']['isSuccess']:
    print("Alert created with HTTP status: {0} and response: {1}".format(status, data))
    alertId = reqData['data']['alertId']
else:
    sys.exit("Creating Alert failed: {}".format(reqData))