/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.context;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.notifications.email.ContextHelper;
import com.xebialabs.xlrelease.notifications.email.templates.Templater;
import com.xebialabs.xlrelease.plugins.remotecompletion.util.FunctionalUtils;
import com.xebialabs.xlrelease.utils.MarkdownProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.collection.JavaConverters;
import scala.collection.Map;

@Service
public class EmailContext {
    private static final String DEFAULT_BODY = "The **${task.title}** task in the **${release.title}** release has started and is assigned to you or your team.\n\nComplete or fail this task using the buttons below.";
    private final ContextHelper contextHelper;

    @Autowired
    public EmailContext(ContextHelper contextHelper) {
        this.contextHelper = contextHelper;
    }

    public java.util.Map<String, Object> buildContext(Task task) {
        List<Task> tasksList = Collections.singletonList(task);
        java.util.Map context = this.contextHelper.tasksContext(JavaConverters.asScalaBuffer(tasksList).toList());
        String taskBody = Templater.processString((String)MarkdownProcessor.process((String)DEFAULT_BODY).orElse(null), (java.util.Map)context);
        String taskSimpleDescription = Optional.ofNullable(task.getDescription()).filter(s -> !s.isEmpty()).map(s -> Templater.processString((String)MarkdownProcessor.process((String)s).orElse(null), (java.util.Map)context)).map(FunctionalUtils.removeFirstOpeningAndClosingPTags).orElse(null);
        context.put("body", taskBody);
        context.put("taskDescription", taskSimpleDescription);
        return context;
    }

    public java.util.Map<String, Object> buildFeedbackContext(String errorMsg, Optional<Task> task) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        task.ifPresent(t -> {
            context.put("context", String.format("for %s: %s", t.getRelease().getTitle(), t.getTitle()));
            context.put("releaseOwner", String.format(": %s", t.getRelease().getOwner()));
        });
        context.put("errorMessage", errorMsg);
        context.putAll(JavaConverters.mapAsJavaMap((Map)this.contextHelper.baseContext()));
        return context;
    }
}

