/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.notifications.email.Email;
import com.xebialabs.xlrelease.notifications.email.templates.Templater;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.CompletionLink;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.SignatureService;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.TaskAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class EmailBuilder {
    private static final String PREFIX_SUBJECT = "[XL Release] ";
    private final SignatureService signatureService;

    public EmailBuilder(SignatureService signatureService) {
        this.signatureService = signatureService;
    }

    public Email buildEmail(Task task, Map<String, Object> context, String emailRecipient, String completionEmail, String templateName) {
        String completeTaskUrlContext = this.getTaskCompletionUrl(task, completionEmail, TaskAction.COMPLETE, emailRecipient);
        String failTaskUrlContext = this.getTaskCompletionUrl(task, completionEmail, TaskAction.FAIL, emailRecipient);
        HashMap<String, Object> emailContext = new HashMap<String, Object>(context);
        emailContext.put("completeTaskUrl", completeTaskUrlContext);
        emailContext.put("failTaskUrl", failTaskUrlContext);
        String subject = PREFIX_SUBJECT + String.format("Action required for %s: %s", task.getRelease().getTitle(), task.getTitle());
        String body = Templater.processTemplate((String)templateName, emailContext);
        return new Email(Collections.singletonList(emailRecipient), subject, body);
    }

    public Set<Email> buildEmails(Task task, Map<String, Object> context, Collection<String> teamEmails, String completionEmail, String templateName) {
        return teamEmails.stream().distinct().map(teamEmail -> this.buildEmail(task, context, (String)teamEmail, completionEmail, templateName)).collect(Collectors.toCollection(HashSet::new));
    }

    public static Email buildFeedbackEmail(Optional<Task> task, Map<String, Object> context, Collection<String> emailRecipients, String templateName) {
        String subject = task.isPresent() ? String.format("%sRequest failed for %s: %s", PREFIX_SUBJECT, task.get().getRelease().getTitle(), task.get().getTitle()) : String.format("%sRequest failed", PREFIX_SUBJECT);
        String body = Templater.processTemplate((String)templateName, context);
        return new Email(emailRecipients, subject, body);
    }

    private String getTaskCompletionUrl(Task task, String completionEmail, TaskAction taskAction, String senderEmail) {
        List<String> to = Collections.singletonList(completionEmail);
        String subject = String.format("%s: %s", new Object[]{taskAction, task.getTitle()});
        String body = String.format("Please send this message to %s task with title '%s' on release '%s'", new Object[]{taskAction, task.getTitle(), task.getRelease().getTitle()});
        CompletionLink link = new CompletionLink(to, subject, body, taskAction, task.getId(), senderEmail, this.signatureService);
        return link.getLink();
    }
}

