/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.web.exchanges.reactive;

import java.security.Principal;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.web.exchanges.HttpExchange;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;
import org.springframework.boot.actuate.web.exchanges.Include;
import org.springframework.boot.actuate.web.exchanges.RecordableHttpResponse;
import org.springframework.boot.actuate.web.exchanges.reactive.RecordableServerHttpRequest;
import org.springframework.boot.actuate.web.exchanges.reactive.RecordableServerHttpResponse;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class HttpExchangesWebFilter
implements WebFilter,
Ordered {
    private static final Object NONE = new Object();
    private int order = 0x7FFFFFF5;
    private final HttpExchangeRepository repository;
    private final Set<Include> includes;

    public HttpExchangesWebFilter(HttpExchangeRepository repository, Set<Include> includes) {
        this.repository = repository;
        this.includes = includes;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Mono principal = exchange.getPrincipal().cast(Object.class).defaultIfEmpty(NONE);
        Mono session = exchange.getSession().cast(Object.class).defaultIfEmpty(NONE);
        return Mono.zip(PrincipalAndSession::new, (Mono[])new Mono[]{principal, session}).flatMap(principalAndSession -> this.filter(exchange, chain, (PrincipalAndSession)principalAndSession));
    }

    private Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain, PrincipalAndSession principalAndSession) {
        return Mono.fromRunnable(() -> this.addExchangeOnCommit(exchange, principalAndSession)).and((Publisher)chain.filter(exchange));
    }

    private void addExchangeOnCommit(ServerWebExchange exchange, PrincipalAndSession principalAndSession) {
        RecordableServerHttpRequest sourceRequest = new RecordableServerHttpRequest(exchange.getRequest());
        HttpExchange.Started startedHttpExchange = HttpExchange.start(sourceRequest);
        exchange.getResponse().beforeCommit(() -> {
            RecordableServerHttpResponse sourceResponse = new RecordableServerHttpResponse(exchange.getResponse());
            HttpExchange finishedExchange = startedHttpExchange.finish((RecordableHttpResponse)sourceResponse, principalAndSession::getPrincipal, principalAndSession::getSessionId, this.includes);
            this.repository.add(finishedExchange);
            return Mono.empty();
        });
    }

    private static class PrincipalAndSession {
        private final Principal principal;
        private final WebSession session;

        PrincipalAndSession(Object[] zipped) {
            this.principal = zipped[0] != NONE ? (Principal)zipped[0] : null;
            this.session = zipped[1] != NONE ? (WebSession)zipped[1] : null;
        }

        Principal getPrincipal() {
            return this.principal;
        }

        String getSessionId() {
            return this.session != null && this.session.isStarted() ? this.session.getId() : null;
        }
    }
}

