/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryMemberPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryRow;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySqlBuilder;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.TrackedItemPersistence;
import com.xebialabs.xlrelease.delivery.service.DeliveryDetailsDecorator$;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.utils.Diff;
import com.xebialabs.xlrelease.utils.Diff$;
import com.xebialabs.xlrelease.utils.ScopedTokenPermissionValidator$;
import com.xebialabs.xlrelease.utils.TenantContext$;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0005\t\u0015h\u0001B\u0011#\u0001=B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!\u0001\u0006A!b\u0001\n\u0007\t\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011m\u0003!Q1A\u0005\u0004qC\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tk\u0002\u0011)\u0019!C\u0001m\"Aq\u0010\u0001B\u0001B\u0003%q\u000fC\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBA=\u0001\u0011\u0005\u00131\u0010\u0005\b\u0003\u000b\u0003A\u0011IAD\u0011\u001d\tY\t\u0001C!\u0003\u001bCq!!'\u0001\t\u0003\nY\nC\u0004\u0002 \u0002!\t%!)\t\u0013\t\u0015\u0001!%A\u0005\u0002\t\u001d\u0001b\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005K\u0001A\u0011\tB\u0014\u0011\u001d\u0011i\u0003\u0001C!\u0005_AqAa\u0010\u0001\t\u0003\u0012\t\u0005C\u0004\u0003V\u0001!IAa\u0016\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h!9!\u0011\u000f\u0001\u0005B\tM\u0004b\u0002B=\u0001\u0011\u0005#1\u0010\u0005\b\u0005\u0013\u0003A\u0011\tBF\u0011\u001d\u0011\u0019\u000b\u0001C!\u0005KCqAa+\u0001\t\u0013\u0011i\u000bC\u0004\u00034\u0002!IA!.\t\u000f\tu\u0006\u0001\"\u0003\u0003@\n)2+\u001d7EK2Lg/\u001a:z%\u0016\u0004xn]5u_JL(BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\n!B]3q_NLGo\u001c:z\u0015\t9\u0003&\u0001\u0005eK2Lg/\u001a:z\u0015\tI#&A\u0005yYJ,G.Z1tK*\u00111\u0006L\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!L\u0001\u0004G>l7\u0001A\n\u0004\u0001A2\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$AB!osJ+g\r\u0005\u00028q5\tA%\u0003\u0002:I\t\u0011B)\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z\u0003M!W\r\\5wKJL\b+\u001a:tSN$XM\\2f!\tat(D\u0001>\u0015\tq$%A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017B\u0001!>\u0005M!U\r\\5wKJL\b+\u001a:tSN$XM\\2f\u0003e!W\r\\5wKJLX*Z7cKJ\u0004VM]:jgR,gnY3\u0011\u0005q\u001a\u0015B\u0001#>\u0005e!U\r\\5wKJLX*Z7cKJ\u0004VM]:jgR,gnY3\u0002-Q\u0014\u0018mY6fI&#X-\u001c)feNL7\u000f^3oG\u0016\u0004\"\u0001P$\n\u0005!k$A\u0006+sC\u000e\\W\rZ%uK6\u0004VM]:jgR,gnY3\u0002)M\fHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s!\tYe*D\u0001M\u0015\t\u0019SJ\u0003\u0002&Q%\u0011q\n\u0014\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM]\u000b\u0002%B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\tg\u0016\u001cWO]5us*\u0011qKK\u0001\tI\u0016\u0004Hn\\=ji&\u0011\u0011\f\u0016\u0002\u0013!\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'/A\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\b%A\u0004eS\u0006dWm\u0019;\u0016\u0003u\u0003\"AX9\u000f\u0005}sgB\u00011m\u001d\t\t'N\u0004\u0002cS:\u00111\r\u001b\b\u0003I\u001el\u0011!\u001a\u0006\u0003M:\na\u0001\u0010:p_Rt\u0014\"A\u0017\n\u0005-b\u0013BA\u0015+\u0013\tY\u0007&\u0001\u0002eE&\u00111%\u001c\u0006\u0003W\"J!a\u001c9\u0002\u0015M\u000bHNQ;jY\u0012,'O\u0003\u0002$[&\u0011!o\u001d\u0002\b\t&\fG.Z2u\u0015\ty\u0007/\u0001\u0005eS\u0006dWm\u0019;!\u0003A!WmY8sCR|'oU3sm&\u001cW-F\u0001x!\tAX0D\u0001z\u0015\tQ80\u0001\u0005j]R,'O\\1m\u0015\ta\b&A\u0002ba&L!A`=\u0003A%sG/\u001a:oC2lU\r^1eCR\fG)Z2pe\u0006$xN]*feZL7-Z\u0001\u0012I\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\t\u0002\u0006\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0002:A\u0019\u0011q\u0001\u0001\u000e\u0003\tBQAO\u0006A\u0002mBQ!Q\u0006A\u0002\tCQ!R\u0006A\u0002\u0019CQ!S\u0006A\u0002)CQ\u0001U\u0006A\u0004ICQaW\u0006A\u0004uC\u0003\"a\u0005\u0002\u0018\u0005M\u0012Q\u0007\t\u0005\u00033\ty#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003C\t\u0019#A\u0004gC\u000e$xN]=\u000b\t\u0005\u0015\u0012qE\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003S\tY#A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\ti#A\u0002pe\u001eLA!!\r\u0002\u001c\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003o\tq\u0003\u001f7s%\u0016\u0004xn]5u_JL8+\u001d7ES\u0006dWm\u0019;\t\u000bU\\\u0001\u0019A<\u0002\tI,\u0017\r\u001a\u000b\u0005\u0003\u007f\ti\u0005\u0005\u0003\u0002B\u0005%SBAA\"\u0015\r9\u0013Q\t\u0006\u0004\u0003\u000fB\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002L\u0005\r#\u0001\u0003#fY&4XM]=\t\u000f\u0005=C\u00021\u0001\u0002R\u0005QA-\u001a7jm\u0016\u0014\u00180\u00133\u0011\t\u0005M\u00131\f\b\u0005\u0003+\n9\u0006\u0005\u0002ee%\u0019\u0011\u0011\f\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\ti&a\u0018\u0003\rM#(/\u001b8h\u0015\r\tIF\r\u0015\u0004\u0019\u0005\r\u0004\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%\u0004/A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BA7\u0003O\u0012!\"S:SK\u0006$wJ\u001c7z\u000399W\r\u001e\"z\u0013\u0012|%\u000fV5uY\u0016$B!a\u0010\u0002t!9\u0011QO\u0007A\u0002\u0005E\u0013!\u00053fY&4XM]=JI>\u0013H+\u001b;mK\"\u001aQ\"a\u0019\u0002\r\r\u0014X-\u0019;f)\u0011\ti(a!\u0011\u0007E\ny(C\u0002\u0002\u0002J\u0012A!\u00168ji\"1qE\u0004a\u0001\u0003\u007f\ta!\u001e9eCR,G\u0003BA?\u0003\u0013CaaJ\bA\u0002\u0005}\u0012AB3ySN$8\u000f\u0006\u0003\u0002\u0010\u0006U\u0005cA\u0019\u0002\u0012&\u0019\u00111\u0013\u001a\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\n\tA\u0002\u0005E\u0003f\u0001\t\u0002d\u00051A-\u001a7fi\u0016$B!! \u0002\u001e\"9\u0011qJ\tA\u0002\u0005E\u0013AB:fCJ\u001c\u0007\u000e\u0006\t\u0002$\u0006U\u0016\u0011ZAk\u0003?\fI/!<\u0002\u0000B1\u0011QUAX\u0003\u007fqA!a*\u0002,:\u0019A-!+\n\u0003MJ1!!,3\u0003\u001d\u0001\u0018mY6bO\u0016LA!!-\u00024\n\u00191+Z9\u000b\u0007\u00055&\u0007C\u0004\u00028J\u0001\r!!/\u0002\u000f\u0019LG\u000e^3sgB!\u00111XAc\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017!\u00024pe6\u001c(bAAbw\u0006\u0011a/M\u0005\u0005\u0003\u000f\fiLA\fBEN$(/Y2u\t\u0016d\u0017N^3ss\u001aKG\u000e^3sg\"9\u00111\u001a\nA\u0002\u00055\u0017\u0001\u00029bO\u0016\u0004B!a4\u0002R6\tQ*C\u0002\u0002T6\u0013A\u0001U1hK\"9\u0011q\u001b\nA\u0002\u0005e\u0017aB8sI\u0016\u0014()\u001f\t\u0005\u0003w\u000bY.\u0003\u0003\u0002^\u0006u&!\u0005#fY&4XM]=Pe\u0012,'/T8eK\"9\u0011\u0011\u001d\nA\u0002\u0005\r\u0018A\u00039sS:\u001c\u0017\u000e]1mgB1\u0011QUAs\u0003#JA!a:\u00024\nA\u0011\n^3sC\ndW\rC\u0004\u0002lJ\u0001\r!a9\u0002\u000fI|G.Z%eg\"9\u0011q\u001e\nA\u0002\u0005E\u0018\u0001E1os>3\u0007+\u001a:nSN\u001c\u0018n\u001c8t!\u0019\t)+a,\u0002tB!\u0011Q_A~\u001b\t\t9PC\u0002\u0002zR\u000b!\u0002]3s[&\u001c8/[8o\u0013\u0011\ti0a>\u0003\u0015A+'/\\5tg&|g\u000eC\u0005\u0003\u0002I\u0001\n\u00111\u0001\u0002\u0010\u0006\u0011RM\u001c4pe\u000e,\u0007+\u001a:nSN\u001c\u0018n\u001c8tQ\r\u0011\u00121M\u0001\u0011g\u0016\f'o\u00195%I\u00164\u0017-\u001e7uI]*\"A!\u0003+\t\u0005=%1B\u0016\u0003\u0005\u001b\u0001BAa\u0004\u0003\u00185\u0011!\u0011\u0003\u0006\u0005\u0005'\u0011)\"A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0004\u001a\n\t\te!\u0011\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!C:fCJ\u001c\u0007.\u00133t)\u0011\u0011yB!\t\u0011\r\u0005\u0015\u0016qVA)\u0011\u001d\t9\f\u0006a\u0001\u0003sC3\u0001FA2\u0003\t2\u0017N\u001c3EK2Lg/\u001a:jKN\u0014VMZ3sK:\u001c\u0017N\\4SK2,\u0017m]3JIR!!q\u0004B\u0015\u0011\u001d\u0011Y#\u0006a\u0001\u0003#\n\u0011B]3mK\u0006\u001cX-\u00133\u0002O\u0019Lg\u000eZ!di&4X\rR3mSZ,'/[3t%\u00164WM]3oG&twMR8mI\u0016\u0014\u0018\n\u001a\u000b\u0005\u0005c\u0011I\u0004\u0005\u0004\u0002&\u0006=&1\u0007\t\u0004y\tU\u0012b\u0001B\u001c{\ti1)[%e/&$\b\u000eV5uY\u0016DqAa\u000f\u0017\u0001\u0004\t\t&\u0001\u0005g_2$WM]%eQ\r1\u00121M\u0001\u0019M&tGMU3mK\u0006\u001cXm\u001d\"z\t\u0016d\u0017N^3ss&#G\u0003\u0002B\"\u0005#\u0002b!!*\u00020\n\u0015\u0003\u0003\u0002B$\u0005\u001bj!A!\u0013\u000b\t\t-\u0013\u0011Y\u0001\u0006m&,wo]\u0005\u0005\u0005\u001f\u0012IEA\fEK2Lg/\u001a:z\r2|wOU3mK\u0006\u001cX-\u00138g_\"9\u0011qJ\fA\u0002\u0005E\u0003fA\f\u0002d\u0005aAo\u001c#fY&4XM]5fgR!\u00111\u0015B-\u0011\u001d\u0011Y\u0006\u0007a\u0001\u0005;\nAA]8xgB1\u0011QUAX\u0005?\u00022\u0001\u0010B1\u0013\r\u0011\u0019'\u0010\u0002\f\t\u0016d\u0017N^3ssJ{w/\u0001\u0006u_\u0012+G.\u001b<fef$b!a\u0010\u0003j\t5\u0004b\u0002B63\u0001\u0007!qL\u0001\u0004e><\bb\u0002B83\u0001\u0007!qD\u0001\u000e]\u0016<(+\u001a7fCN,\u0017\nZ:\u0002\u0019\u0019Lg\u000e\u001a$pY\u0012,'/\u00133\u0015\t\u0005E#Q\u000f\u0005\b\u0003\u001fR\u0002\u0019AA)Q\rQ\u00121M\u0001\u0013M&tG\rU1ui\u0016\u0014hNQ=USRdW\r\u0006\u0003\u0003~\t\r\u0005#B\u0019\u0003\u0000\u0005}\u0012b\u0001BAe\t1q\n\u001d;j_:DqA!\"\u001c\u0001\u0004\t\t&A\u0003uSRdW\rK\u0002\u001c\u0003G\n!\u0003^3oC:$\b+\u0019;uKJt7i\\;oiR!!Q\u0012BO!\u0011\u0011yI!'\u000e\u0005\tE%\u0002\u0002BJ\u0005+\u000bA\u0001\\1oO*\u0011!qS\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u001c\nE%aB%oi\u0016<WM\u001d\u0005\b\u0005?c\u0002\u0019AA)\u0003!!XM\\1oi&#\u0007f\u0001\u000f\u0002d\u0005\u0019B/\u001a8b]R$U\r\\5wKJL8i\\;oiR!!Q\u0012BT\u0011\u001d\u0011y*\ba\u0001\u0003#B3!HA2\u00039\"WmY8sCR,w+\u001b;i\u000b\u001a4Wm\u0019;jm\u0016\u001cVmY;sSRL\u0018I\u001c3QCR$XM\u001d8EKR\f\u0017\u000e\\:\u0015\t\u0005\r&q\u0016\u0005\b\u0005cs\u0002\u0019AAR\u0003)!W\r\\5wKJLWm]\u0001\u000e[\u0006\u0004Hk\u001c#fY&4XM]=\u0015\t\tu$q\u0017\u0005\b\u0005s{\u0002\u0019\u0001B^\u00039!W\r\\5wKJL(k\\<PaR\u0004R!\rB@\u0005?\nA#\u0019:f\u0013R,Wn]%o)\u0006\u0014G.Z#rk\u0006dGCBAH\u0005\u0003\u0014Y\rC\u0004\u0003D\u0002\u0002\rA!2\u0002\u000f=dG-\u0013;f[B!\u0011\u0011\tBd\u0013\u0011\u0011I-a\u0011\u0003\u0017Q\u0013\u0018mY6fI&#X-\u001c\u0005\b\u0005\u001b\u0004\u0003\u0019\u0001Bc\u0003\u001dqWm^%uK6D3\u0001\u0001Bi!\u0011\t)Ga5\n\t\tU\u0017q\r\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\"\u001a\u0001A!7\u0011\t\tm'\u0011]\u0007\u0003\u0005;TAAa8\u0002(\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\t\r(Q\u001c\u0002\u000b%\u0016\u0004xn]5u_JL\b")
public class SqlDeliveryRepository
implements DeliveryRepository {
    private final DeliveryPersistence deliveryPersistence;
    private final DeliveryMemberPersistence deliveryMemberPersistence;
    private final TrackedItemPersistence trackedItemPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect dialect;
    private final InternalMetadataDecoratorService decoratorService;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Delivery>> persistenceInterceptors;

    @Override
    public void createOrUpdate(Delivery delivery) {
        DeliveryRepository.createOrUpdate$(this, delivery);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Delivery> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Delivery>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Delivery>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    @IsReadOnly
    public Delivery read(String deliveryId) {
        return (Delivery)this.mapToDelivery(this.deliveryPersistence.findById(deliveryId)).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release delivery " + deliveryId + " not found", new Object[0]);
        });
    }

    @Override
    @IsReadOnly
    public Delivery getByIdOrTitle(String deliveryIdOrTitle) {
        return (Delivery)this.mapToDelivery((Option<DeliveryRow>)this.deliveryPersistence.findById(deliveryIdOrTitle).orElse((Function0 & Serializable)() -> $this.deliveryPersistence.findByTitle(deliveryIdOrTitle))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release delivery " + deliveryIdOrTitle + " not found", new Object[0]);
        });
    }

    @Override
    public void create(Delivery delivery) {
        delivery.setTenantId(TenantContext$.MODULE$.getTenant());
        this.interceptCreate((ConfigurationItem)delivery);
        Integer deliveryUid = this.deliveryPersistence.insert(delivery);
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(delivery.getReleaseIds()).asScala().toSet());
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().toSet());
    }

    @Override
    public void update(Delivery delivery) {
        Delivery originalDelivery = this.read(delivery.getId());
        Integer deliveryUid = (Integer)this.deliveryPersistence.getUid(delivery.getId()).get();
        CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala();
        Diff itemDiff = Diff$.MODULE$.applyWithKeyMappingAndComparator((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(originalDelivery.getTrackedItems()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala(), (Function1 & Serializable)x$1 -> x$1.getId(), (Function2 & Serializable)(oldItem, newItem) -> BoxesRunTime.boxToBoolean((boolean)this.areItemsInTableEqual(oldItem, newItem)));
        itemDiff.updatedValues().foreach((Function1 & Serializable)item -> {
            this.trackedItemPersistence.updateTrackedItem(item.getId(), item);
            return BoxedUnit.UNIT;
        });
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)itemDiff.newValues().toSet());
        this.trackedItemPersistence.deleteItems(deliveryUid, (scala.collection.immutable.Set<String>)itemDiff.deletedKeys());
        delivery.computeReleasesFromTrackedItems();
        Diff membersDiff = Diff$.MODULE$.apply((Iterable)CollectionConverters$.MODULE$.SetHasAsScala(originalDelivery.getReleaseIds()).asScala(), (Iterable)CollectionConverters$.MODULE$.SetHasAsScala(delivery.getReleaseIds()).asScala());
        this.deliveryMemberPersistence.deleteMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.deletedKeys());
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.newKeys());
        this.deliveryPersistence.update(delivery);
    }

    @Override
    @IsReadOnly
    public boolean exists(String deliveryId) {
        return this.deliveryPersistence.exists(deliveryId);
    }

    @Override
    public void delete(String deliveryId) {
        this.deliveryPersistence.delete(deliveryId);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy, Iterable<String> principals, Iterable<String> roleIds, scala.collection.immutable.Seq<Permission> anyOfPermissions, boolean enforcePermissions) {
        scala.collection.immutable.Seq<DeliveryRow> seq;
        scala.collection.immutable.Seq<Permission> permissions;
        if (!enforcePermissions || this.permissionEnforcer().isCurrentUserAdmin() || this.permissionEnforcer().hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL})) {
            v0 = (scala.collection.immutable.Seq<Permission>)package$.MODULE$.Seq().empty();
        } else {
            ScopedTokenPermissionValidator$.MODULE$.checkPermissionSupportedinScopedToken(anyOfPermissions);
            v0 = permissions = anyOfPermissions;
        }
        if (filters.hasStatuses()) {
            String string;
            DeliverySqlBuilder deliverySqlBuilder = new DeliverySqlBuilder(this.dialect()).select().withTitleLike(filters.getTitle(), filters.isStrictTitleMatch()).withTrackedItemTitleLike(filters.getTrackedItemTitle(), filters.isStrictTrackedItemTitleMatch()).withOneOfStatuses((scala.collection.immutable.Seq<DeliveryStatus>)((scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)filters.getStatuses()).map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2).asScala().toSeq()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))).withFolder(filters.getFolderId()).withPermissions(permissions, principals, roleIds);
            AbstractDeliveryFilters abstractDeliveryFilters = filters;
            if (abstractDeliveryFilters instanceof DeliveryFilters) {
                DeliveryFilters deliveryFilters = (DeliveryFilters)abstractDeliveryFilters;
                string = deliveryFilters.getOriginPatternId();
            } else {
                string = null;
            }
            Tuple2 sqlWithParams = deliverySqlBuilder.withOriginPatternId(string).orderBy(orderBy).limitAndOffset(page.resultsPerPage(), page.resultsPerPage() * page.page()).build();
            seq = this.deliveryPersistence.findByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams);
        } else {
            seq = (scala.collection.immutable.Seq<DeliveryRow>)package$.MODULE$.Seq().empty();
        }
        scala.collection.immutable.Seq<DeliveryRow> deliveryRows = seq;
        scala.collection.immutable.Seq<Delivery> deliveries = this.toDeliveries(deliveryRows);
        if (this.permissionEnforcer().isCurrentUserAdmin() || this.permissionEnforcer().hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL})) {
            return deliveries;
        }
        return this.decorateWithEffectiveSecurityAndPatternDetails(deliveries);
    }

    @Override
    public boolean search$default$7() {
        return true;
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<String> searchIds(AbstractDeliveryFilters filters) {
        Tuple2 sqlWithParams = new DeliverySqlBuilder(this.dialect()).select().withTitle(filters.getTitle()).withOneOfStatuses((scala.collection.immutable.Seq<DeliveryStatus>)((scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)filters.getStatuses()).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSeq()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))).withFolder(filters.getFolderId()).build();
        return (scala.collection.immutable.Seq)this.deliveryPersistence.findByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).map((Function1 & Serializable)x$4 -> x$4.domainId());
    }

    @Override
    public scala.collection.immutable.Seq<String> findDeliveriesReferencingReleaseId(String releaseId) {
        return this.deliveryMemberPersistence.findDeliveriesReferencingReleaseId(releaseId);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolderId(String folderId) {
        return this.deliveryMemberPersistence.findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<DeliveryFlowReleaseInfo> findReleasesByDeliveryId(String deliveryId) {
        return (scala.collection.immutable.Seq)this.deliveryPersistence.findReleasesByDeliveryId(deliveryId).map((Function1 & Serializable)row -> new DeliveryFlowReleaseInfo(row.id(), row.title(), row.status(), row.startDate(), row.endDate(), false));
    }

    private scala.collection.immutable.Seq<Delivery> toDeliveries(scala.collection.immutable.Seq<DeliveryRow> rows) {
        Map<Object, scala.collection.immutable.Seq<String>> releaseIdsByDelivery = this.deliveryMemberPersistence.findMembersByDeliveryUids((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)rows.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.ciUid()))));
        return (scala.collection.immutable.Seq)rows.map((Function1 & Serializable)row -> this.toDelivery((DeliveryRow)row, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)releaseIdsByDelivery.getOrElse((Object)BoxesRunTime.boxToInteger((int)row.ciUid()), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
    }

    private Delivery toDelivery(DeliveryRow row, scala.collection.immutable.Seq<String> newReleaseIds) {
        Option deliveryOption = this.sqlRepositoryAdapter.deserialize(row.content());
        Option option = deliveryOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            Delivery delivery = (Delivery)some.value();
            delivery.setFolderId(row.folderId().absolute());
            Set mergedReleaseIds = (Set)CollectionConverters$.MODULE$.SetHasAsScala(delivery.getReleaseIds()).asScala().map((Function1 & Serializable)oldId -> (String)newReleaseIds.find((Function1 & Serializable)newId -> BoxesRunTime.boxToBoolean((boolean)SqlDeliveryRepository.$anonfun$toDelivery$2(oldId, newId))).getOrElse((Function0 & Serializable)() -> oldId));
            delivery.setReleaseIds(new HashSet(CollectionConverters$.MODULE$.MutableSetHasAsJava(mergedReleaseIds).asJava()));
            delivery.setTenantId(row.tenantId());
            return delivery;
        }
        if (None$.MODULE$.equals(option)) {
            throw new LogFriendlyNotFoundException("Error reading release delivery " + row.ciUid() + ", see logs for more details", new Object[0]);
        }
        throw new MatchError((Object)option);
    }

    @Override
    @IsReadOnly
    public String findFolderId(String deliveryId) {
        return this.deliveryPersistence.findFolderId(deliveryId).absolute();
    }

    @Override
    @IsReadOnly
    public Option<Delivery> findPatternByTitle(String title) {
        return this.mapToDelivery(this.deliveryPersistence.findPatternByTitle(title));
    }

    @Override
    @IsReadOnly
    public Integer tenantPatternCount(String tenantId) {
        return this.deliveryPersistence.tenantDeliveryCount(tenantId, DeliveryStatus.TEMPLATE);
    }

    @Override
    @IsReadOnly
    public Integer tenantDeliveryCount(String tenantId) {
        return this.deliveryPersistence.tenantDeliveryCount(tenantId, DeliveryStatus.IN_PROGRESS);
    }

    private scala.collection.immutable.Seq<Delivery> decorateWithEffectiveSecurityAndPatternDetails(scala.collection.immutable.Seq<Delivery> deliveries) {
        return (scala.collection.immutable.Seq)deliveries.map((Function1 & Serializable)delivery -> {
            this.decoratorService().decorate((ConfigurationItem)delivery, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)new .colon.colon((Object)DeliveryDetailsDecorator$.MODULE$.DELIVERY_DETAILS(), (List)Nil$.MODULE$))).asJava());
            return delivery;
        });
    }

    private Option<Delivery> mapToDelivery(Option<DeliveryRow> deliveryRowOpt) {
        return deliveryRowOpt.map((Function1 & Serializable)row -> this.toDelivery((DeliveryRow)row, $this.deliveryMemberPersistence.findMembersByDeliveryUid(Predef$.MODULE$.int2Integer(row.ciUid())))).map((Function1 & Serializable)delivery -> (Delivery)this.decorateWithEffectiveSecurityAndPatternDetails((scala.collection.immutable.Seq<Delivery>)new .colon.colon(delivery, (List)Nil$.MODULE$)).head());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areItemsInTableEqual(TrackedItem oldItem, TrackedItem newItem) {
        String string = oldItem.getTitle();
        String string2 = newItem.getTitle();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (oldItem.isDescoped() != newItem.isDescoped()) return false;
        Date date = oldItem.getModifiedDate();
        Date date2 = newItem.getModifiedDate();
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$toDelivery$2(String oldId$1, String newId) {
        String string = Ids.getName((String)newId);
        String string2 = Ids.getName((String)oldId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDeliveryRepository(DeliveryPersistence deliveryPersistence, DeliveryMemberPersistence deliveryMemberPersistence, TrackedItemPersistence trackedItemPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, PermissionEnforcer permissionEnforcer, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, InternalMetadataDecoratorService decoratorService) {
        this.deliveryPersistence = deliveryPersistence;
        this.deliveryMemberPersistence = deliveryMemberPersistence;
        this.trackedItemPersistence = trackedItemPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.dialect = dialect;
        this.decoratorService = decoratorService;
        InterceptedRepository.$init$((InterceptedRepository)this);
        DeliveryRepository.$init$(this);
    }
}

