/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.DB;
import com.versionone.Oid;
import com.versionone.apiclient.Asset;
import com.versionone.apiclient.exceptions.APIException;
import com.versionone.apiclient.interfaces.IAttributeDefinition;

public abstract class Attribute {
    private IAttributeDefinition _def;
    private Asset _asset;

    protected Attribute(IAttributeDefinition def, Asset asset) {
        this._def = def;
        this._asset = asset;
    }

    public Asset getAsset() {
        return this._asset;
    }

    public IAttributeDefinition getDefinition() {
        return this._def;
    }

    public abstract Object getOriginalValue() throws APIException;

    public abstract Object getNewValue() throws APIException;

    public Object getValue() throws APIException {
        if (this.hasChanged()) {
            return this.getNewValue();
        }
        return this.getOriginalValue();
    }

    public abstract Object[] getOriginalValues();

    public abstract Object[] getNewValues();

    public abstract Object[] getAddedValues();

    public abstract Object[] getRemovedValues();

    public Object[] getValues() {
        if (this.hasChanged()) {
            return this.getNewValues();
        }
        return this.getOriginalValues();
    }

    public abstract boolean hasChanged();

    public abstract void acceptChanges();

    public abstract void rejectChanges();

    protected void checkReadOnly() {
        if (this._def.isReadOnly()) {
            throw new RuntimeException("Cannot assign new value to a read-only attribute: " + this.getDefinition().getToken());
        }
    }

    protected void checkNull(Object value) {
        if ((this._def.isRequired() || this._def.isMultiValue() && this._def.getAttributeType() == IAttributeDefinition.AttributeType.Relation) && (value == DB.Null || value instanceof Oid && ((Oid)value).isNull())) {
            throw new RuntimeException("Value required: " + this.getDefinition().getToken());
        }
    }

    abstract void loadValue(Object var1) throws APIException;

    abstract void setValue(Object var1) throws APIException;

    abstract void forceValue(Object var1) throws APIException;

    abstract void addValue(Object var1) throws APIException;

    abstract void removeValue(Object var1) throws APIException;
}

