/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.utils;

import com.versionone.utils.IDelegate;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

public class Delegator {
    public static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Delegator[] EMPTY_ARRAY = new Delegator[0];
    public static final Delegator RUNNABLE_DELEGATE = new Delegator(Runnable.class);
    private final Class m_Interface;
    private final Class m_Return;
    private final Class[] m_Arguments;

    public static Runnable buildRunnable(Object item, String methodName) {
        return (Runnable)((Object)RUNNABLE_DELEGATE.build(item, methodName));
    }

    public static Runnable buildRunnable(Class item, String methodName) {
        return (Runnable)((Object)RUNNABLE_DELEGATE.build(item, methodName));
    }

    public Delegator(Class[] params, Class retClass) {
        this.m_Interface = null;
        this.m_Return = retClass;
        this.m_Arguments = params;
    }

    public Delegator(Class TheInterface) {
        this.m_Interface = TheInterface;
        Method met = Delegator.findMethod(TheInterface);
        this.m_Return = met.getReturnType();
        this.m_Arguments = met.getParameterTypes();
    }

    public Class getReturn() {
        return this.m_Return;
    }

    public Class[] getArguments() {
        return this.m_Arguments;
    }

    public Class getInterface() {
        return this.m_Interface;
    }

    public IDelegate build(Class target, String MethodName) {
        Class myInterface = this.getInterface();
        DelegateProxy theDelegate = new DelegateProxy(null, target, MethodName, this);
        if (myInterface != null) {
            Class[] interfaces = new Class[]{myInterface, IDelegate.class};
            IDelegate ret = (IDelegate)Proxy.newProxyInstance(target.getClassLoader(), interfaces, (InvocationHandler)theDelegate);
            return ret;
        }
        return theDelegate;
    }

    public IDelegate build(Object target, String MethodName) {
        Class myInterface = this.getInterface();
        DelegateProxy theDelegate = new DelegateProxy(target, target.getClass(), MethodName, this);
        if (myInterface != null) {
            Class[] interfaces = new Class[]{myInterface, IDelegate.class};
            IDelegate ret = (IDelegate)Proxy.newProxyInstance(target.getClass().getClassLoader(), interfaces, (InvocationHandler)theDelegate);
            return ret;
        }
        if (!(theDelegate instanceof IDelegate)) {
            throw new ClassCastException();
        }
        return theDelegate;
    }

    protected static boolean isSuitableMethod(Method testMethod, Class[] args, Class retClass) {
        Class<?>[] methodArgs = testMethod.getParameterTypes();
        for (int i = 0; i < methodArgs.length; ++i) {
            Class<?> arg = methodArgs[i];
            if (arg.isAssignableFrom(args[i])) continue;
            return false;
        }
        Delegator.isValidReturn(testMethod, retClass);
        return true;
    }

    protected static Method[] getCandidateMethods(Class targetClass, String MethodName, int nargs) {
        Method[] possibilities = targetClass.getMethods();
        ArrayList<Method> holder = new ArrayList<Method>();
        for (int i = 0; i < possibilities.length; ++i) {
            Method possibility = possibilities[i];
            if (!possibility.getName().equals(MethodName) || possibility.getParameterTypes().length != nargs || !Modifier.isPublic(possibility.getModifiers())) continue;
            holder.add(possibility);
        }
        return holder.toArray(EMPTY_METHOD_ARRAY);
    }

    protected static boolean isValidReturn(Method test, Class retClass) {
        if (retClass == null) {
            return true;
        }
        if (test.getReturnType() == retClass) {
            return true;
        }
        return retClass.isAssignableFrom(test.getReturnType());
    }

    protected static Method findSuitableMethod(Class targetClass, String MethodName, Delegator templ) {
        Class[] args = templ.getArguments();
        Class retClass = templ.getReturn();
        try {
            Method ret = targetClass.getMethod(MethodName, args);
            if (!Delegator.isValidReturn(ret, retClass)) {
                throw new IllegalArgumentException("Requested method returns wrong type");
            }
            if (!Modifier.isPublic(ret.getModifiers())) {
                throw new IllegalArgumentException("Requested method is not public");
            }
            return ret;
        }
        catch (Exception ret) {
            Method[] possibilities = Delegator.getCandidateMethods(targetClass, MethodName, args.length);
            for (int i = 0; i < possibilities.length; ++i) {
                Method possibility = possibilities[i];
                if (!Delegator.isSuitableMethod(possibility, args, retClass)) continue;
                return possibility;
            }
            throw new IllegalArgumentException("No suitable method found");
        }
    }

    protected static Method findMethod(Class TheInterface) {
        if (!TheInterface.isInterface()) {
            throw new IllegalArgumentException("DelegateTemplate must be constructed with an interface");
        }
        Method[] methods = TheInterface.getMethods();
        Method ret = null;
        for (int i = 0; i < methods.length; ++i) {
            Method test = methods[i];
            if (!Modifier.isAbstract(test.getModifiers())) continue;
            if (ret != null) {
                throw new IllegalArgumentException("DelegateTemplate must be constructed with an interface implementing only one method!");
            }
            ret = test;
        }
        if (ret == null) {
            throw new IllegalArgumentException("DelegateTemplate must be constructed with an interface implementing exactly method!");
        }
        return ret;
    }

    public static class DelegateInvokeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DelegateInvokeException(Throwable cause) {
            super(cause);
        }
    }

    protected class DelegateProxy
    implements IDelegate,
    InvocationHandler {
        private final Method m_Method;
        private final Object m_Target;
        private final Delegator m_Template;

        protected DelegateProxy(Object target, Class targetClass, String methodName, Delegator template) {
            this.m_Template = template;
            this.m_Target = target;
            this.m_Method = Delegator.findSuitableMethod(targetClass, methodName, template);
        }

        @Override
        public Object invoke() throws IllegalArgumentException, DelegateInvokeException {
            return this.invoke(EMPTY_OBJECT_ARRAY);
        }

        @Override
        public Object invoke(Object arg) throws IllegalArgumentException, DelegateInvokeException {
            Object[] args = new Object[]{arg};
            return this.invoke(args);
        }

        @Override
        public Object invoke(Object arg1, Object arg2) throws IllegalArgumentException, DelegateInvokeException {
            Object[] args = new Object[]{arg1, arg2};
            return this.invoke(args);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            return this.invoke(args);
        }

        @Override
        public Object invoke(Object[] args) throws IllegalArgumentException, DelegateInvokeException {
            try {
                Object ret = this.getMethod().invoke(this.getTarget(), args);
                return ret;
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Bad Delegate State: " + ex.getMessage());
            }
            catch (InvocationTargetException ex) {
                throw new DelegateInvokeException(ex.getCause());
            }
        }

        protected void validateArgs(Object[] args) throws IllegalArgumentException {
            Class[] MyArgs = Delegator.this.getArguments();
            if (args.length != MyArgs.length) {
                throw new IllegalArgumentException("Delegate required " + MyArgs.length + "arguments");
            }
            for (int i = 0; i < args.length; ++i) {
                if (MyArgs[i].isInstance(args[i])) continue;
                throw new IllegalArgumentException("Argument " + i + " must be of class " + MyArgs[i].getName());
            }
        }

        public Method getMethod() {
            return this.m_Method;
        }

        public Object getTarget() {
            return this.m_Target;
        }
    }
}

