/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management;

import com.typesafe.config.Config;
import java.time.Duration;
import java.util.List;
import org.apache.pekko.management.HealthCheckSettings$;
import org.apache.pekko.management.NamedHealthCheck;
import org.apache.pekko.util.ccompat.package;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\rt!\u0002\u000f\u001e\u0011\u00031c!\u0002\u0015\u001e\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004\"\u0002\u001a\u0002\t\u0003\u0019\u0004bBA\u001d\u0003\u0011\u0005\u00111\b\u0005\b\u0003s\tA\u0011AA \u0011\u001d\tI$\u0001C\u0001\u0003#2A\u0001K\u000f\u0003k!Aag\u0002BC\u0002\u0013\u0005q\u0007\u0003\u0005D\u000f\t\u0005\t\u0015!\u00039\u0011!!uA!b\u0001\n\u00039\u0004\u0002C#\b\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011\u0019;!Q1A\u0005\u0002]B\u0001bR\u0004\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0011\u001e\u0011)\u0019!C\u0001\u0013\"AQk\u0002B\u0001B\u0003%!\n\u0003\u0005W\u000f\t\u0015\r\u0011\"\u0001J\u0011!9vA!A!\u0002\u0013Q\u0005\u0002\u0003-\b\u0005\u000b\u0007I\u0011A%\t\u0011e;!\u0011!Q\u0001\n)C\u0001BW\u0004\u0003\u0006\u0004%\ta\u0017\u0005\tI\u001e\u0011\t\u0011)A\u00059\")\u0001g\u0002C\u0001K\")\u0001g\u0002C\u0001[\")Qp\u0002C\u0001}\"1\u0011qB\u0004\u0005\u0002yDa!!\u0005\b\t\u0003q\bbBA\n\u000f\u0011\u0005\u0011QC\u0001\u0014\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7nU3ui&twm\u001d\u0006\u0003=}\t!\"\\1oC\u001e,W.\u001a8u\u0015\t\u0001\u0013%A\u0003qK.\\wN\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001\u0001\t\u0003O\u0005i\u0011!\b\u0002\u0014\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7nU3ui&twm]\n\u0003\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001'\u0003\u0015\t\u0007\u000f\u001d7z)\r!\u00141\u0005\t\u0003O\u001d\u0019\"a\u0002\u0016\u0002\u001bM$\u0018M\u001d;va\u000eCWmY6t+\u0005A\u0004cA\u001d?\u00016\t!H\u0003\u0002<y\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003{1\n!bY8mY\u0016\u001cG/[8o\u0013\ty$HA\u0002TKF\u0004\"aJ!\n\u0005\tk\"\u0001\u0005(b[\u0016$\u0007*Z1mi\"\u001c\u0005.Z2l\u00039\u0019H/\u0019:ukB\u001c\u0005.Z2lg\u0002\nqB]3bI&tWm]:DQ\u0016\u001c7n]\u0001\u0011e\u0016\fG-\u001b8fgN\u001c\u0005.Z2lg\u0002\na\u0002\\5wK:,7o]\"iK\u000e\\7/A\bmSZ,g.Z:t\u0007\",7m[:!\u0003-\u0019H/\u0019:ukB\u0004\u0016\r\u001e5\u0016\u0003)\u0003\"a\u0013*\u000f\u00051\u0003\u0006CA'-\u001b\u0005q%BA(&\u0003\u0019a$o\\8u}%\u0011\u0011\u000bL\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002RY\u0005a1\u000f^1siV\u0004\b+\u0019;iA\u0005i!/Z1eS:,7o\u001d)bi\"\faB]3bI&tWm]:QCRD\u0007%\u0001\u0007mSZ,g.Z:t!\u0006$\b.A\u0007mSZ,g.Z:t!\u0006$\b\u000eI\u0001\rG\",7m\u001b+j[\u0016|W\u000f^\u000b\u00029B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\tIV\u0014\u0018\r^5p]*\u0011\u0011\rL\u0001\u000bG>t7-\u001e:sK:$\u0018BA2_\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fQb\u00195fG.$\u0016.\\3pkR\u0004C\u0003\u0003\u001bgO\"L'n\u001b7\t\u000bY2\u0002\u0019\u0001\u001d\t\u000b\u00113\u0002\u0019\u0001\u001d\t\u000b\u00193\u0002\u0019\u0001\u001d\t\u000b!3\u0002\u0019\u0001&\t\u000bY3\u0002\u0019\u0001&\t\u000ba3\u0002\u0019\u0001&\t\u000bi3\u0002\u0019\u0001/\u0015\rQrw\u000e]9s\u0011\u0015!u\u00031\u00019\u0011\u00151u\u00031\u00019\u0011\u00151v\u00031\u0001K\u0011\u0015Av\u00031\u0001K\u0011\u0015Qv\u00031\u0001]Q\u00199Bo\u001e={wB\u00111&^\u0005\u0003m2\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3e\u0003\u001diWm]:bO\u0016\f\u0013!_\u0001P+N,\u0007eY8ogR\u0014Xo\u0019;pe\u0002\"\b.\u0019;!i\u0006\\Wm\u001d\u0011agR\f'\u000f^;q\u0007\",7m[:aA\u0005tG\r\t1ti\u0006\u0014H/\u001e9QCRD\u0007\r\t9be\u0006lW\r^3sg\u0002Jgn\u001d;fC\u0012\fQa]5oG\u0016\f\u0013\u0001`\u0001\u0006c9\nd\u0006M\u0001\u0011O\u0016$8\u000b^1siV\u00048\t[3dWN$\u0012a \t\u0006\u0003\u0003\tY\u0001Q\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005!Q\u000f^5m\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011A\u0001T5ti\u0006\u0011r-\u001a;SK\u0006$\u0017N\\3tg\u000eCWmY6t\u0003E9W\r\u001e'jm\u0016tWm]:DQ\u0016\u001c7n]\u0001\u0010O\u0016$8\t[3dWRKW.Z8viR\u0011\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)!\u0011QDA\u0004\u0003\u0011!\u0018.\\3\n\t\u0005\u0005\u00121\u0004\u0002\t\tV\u0014\u0018\r^5p]\"9\u0011QE\u0002A\u0002\u0005\u001d\u0012AB2p]\u001aLw\r\u0005\u0003\u0002*\u0005URBAA\u0016\u0015\u0011\t)#!\f\u000b\t\u0005=\u0012\u0011G\u0001\tif\u0004Xm]1gK*\u0011\u00111G\u0001\u0004G>l\u0017\u0002BA\u001c\u0003W\u0011aaQ8oM&<\u0017AB2sK\u0006$X\rF\u00025\u0003{Aq!!\n\u0005\u0001\u0004\t9\u0003F\b5\u0003\u0003\n\u0019%!\u0012\u0002H\u0005%\u00131JA'\u0011\u00151T\u00011\u0001\u0000\u0011\u0015!U\u00011\u0001\u0000\u0011\u00151U\u00011\u0001\u0000\u0011\u0015AU\u00011\u0001K\u0011\u00151V\u00011\u0001K\u0011\u0015AV\u00011\u0001K\u0011\u001d\ty%\u0002a\u0001\u0003/\tQb\u00195fG.$UO]1uS>tGc\u0003\u001b\u0002T\u0005U\u0013qKA-\u00037BQ\u0001\u0012\u0004A\u0002}DQA\u0012\u0004A\u0002}DQA\u0016\u0004A\u0002)CQ\u0001\u0017\u0004A\u0002)Cq!a\u0014\u0007\u0001\u0004\t9\u0002K\u0004\u0007i^\fyF_>\"\u0005\u0005\u0005\u0014AS+tK\u0002\u001a'/Z1uK\u0002\"\b.\u0019;!i\u0006\\Wm\u001d\u0011agR\f'\u000f^;q\u0007\",7m[:aA\u0005tG\r\t1ti\u0006\u0014H/\u001e9QCRD\u0007\r\t9be\u0006lW\r^3sg\u0002Jgn\u001d;fC\u0012\u0004")
public final class HealthCheckSettings {
    private final Seq<NamedHealthCheck> startupChecks;
    private final Seq<NamedHealthCheck> readinessChecks;
    private final Seq<NamedHealthCheck> livenessChecks;
    private final String startupPath;
    private final String readinessPath;
    private final String livenessPath;
    private final FiniteDuration checkTimeout;

    public static HealthCheckSettings create(List<NamedHealthCheck> readinessChecks, List<NamedHealthCheck> livenessChecks, String readinessPath, String livenessPath, Duration checkDuration) {
        return HealthCheckSettings$.MODULE$.create(readinessChecks, livenessChecks, readinessPath, livenessPath, checkDuration);
    }

    public static HealthCheckSettings create(List<NamedHealthCheck> startupChecks, List<NamedHealthCheck> readinessChecks, List<NamedHealthCheck> livenessChecks, String startupPath, String readinessPath, String livenessPath, Duration checkDuration) {
        return HealthCheckSettings$.MODULE$.create(startupChecks, readinessChecks, livenessChecks, startupPath, readinessPath, livenessPath, checkDuration);
    }

    public static HealthCheckSettings create(Config config) {
        return HealthCheckSettings$.MODULE$.apply(config);
    }

    public static HealthCheckSettings apply(Config config) {
        return HealthCheckSettings$.MODULE$.apply(config);
    }

    public Seq<NamedHealthCheck> startupChecks() {
        return this.startupChecks;
    }

    public Seq<NamedHealthCheck> readinessChecks() {
        return this.readinessChecks;
    }

    public Seq<NamedHealthCheck> livenessChecks() {
        return this.livenessChecks;
    }

    public String startupPath() {
        return this.startupPath;
    }

    public String readinessPath() {
        return this.readinessPath;
    }

    public String livenessPath() {
        return this.livenessPath;
    }

    public FiniteDuration checkTimeout() {
        return this.checkTimeout;
    }

    public List<NamedHealthCheck> getStartupChecks() {
        return package.JavaConverters$.MODULE$.SeqHasAsJava(this.startupChecks()).asJava();
    }

    public List<NamedHealthCheck> getReadinessChecks() {
        return package.JavaConverters$.MODULE$.SeqHasAsJava(this.readinessChecks()).asJava();
    }

    public List<NamedHealthCheck> getLivenessChecks() {
        return package.JavaConverters$.MODULE$.SeqHasAsJava(this.livenessChecks()).asJava();
    }

    public Duration getCheckTimeout() {
        return Duration.ofNanos(this.checkTimeout().toNanos());
    }

    public HealthCheckSettings(Seq<NamedHealthCheck> startupChecks, Seq<NamedHealthCheck> readinessChecks, Seq<NamedHealthCheck> livenessChecks, String startupPath, String readinessPath, String livenessPath, FiniteDuration checkTimeout) {
        this.startupChecks = startupChecks;
        this.readinessChecks = readinessChecks;
        this.livenessChecks = livenessChecks;
        this.startupPath = startupPath;
        this.readinessPath = readinessPath;
        this.livenessPath = livenessPath;
        this.checkTimeout = checkTimeout;
    }

    public HealthCheckSettings(Seq<NamedHealthCheck> readinessChecks, Seq<NamedHealthCheck> livenessChecks, String readinessPath, String livenessPath, FiniteDuration checkTimeout) {
        this((Seq<NamedHealthCheck>)Nil$.MODULE$, readinessChecks, livenessChecks, "", readinessPath, livenessPath, checkTimeout);
    }
}

