/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management.scaladsl;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.ExtensionIdProvider;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.http.javadsl.server.directives.SecurityDirectives;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.ServerBuilder;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directives$;
import org.apache.pekko.http.scaladsl.server.PathMatcher$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.RouteResult$;
import org.apache.pekko.http.scaladsl.server.directives.Credentials;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.http.scaladsl.settings.ServerSettings$;
import org.apache.pekko.management.ManagementLogMarker$;
import org.apache.pekko.management.PekkoManagementSettings;
import org.apache.pekko.management.scaladsl.ManagementRouteProvider;
import org.apache.pekko.management.scaladsl.ManagementRouteProviderAdapter;
import org.apache.pekko.management.scaladsl.ManagementRouteProviderSettings;
import org.apache.pekko.management.scaladsl.ManagementRouteProviderSettingsImpl;
import org.apache.pekko.management.scaladsl.PekkoManagement$;
import org.apache.pekko.util.ManifestInfo;
import org.apache.pekko.util.ManifestInfo$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.jdk.javaapi.FutureConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005mv!B\u000f\u001f\u0011\u0003Ic!B\u0016\u001f\u0011\u0003a\u0003B\u0002#\u0002\t\u0003\t9\nC\u0004\u0002\u001a\u0006!\t%a'\t\u000f\u0005}\u0015\u0001\"\u0011\u0002\"\"9\u0011qT\u0001\u0005B\u0005-\u0006bBA[\u0003\u0011\u0005\u0013q\u0017\u0004\u0005Wy\u0011!\bC\u0005?\u000f\t\u0015\r\u0011b\u0001#\u007f!A1i\u0002B\u0001B\u0003%\u0001\tC\u0003E\u000f\u0011\u0005Q\tC\u0004I\u000f\t\u0007I\u0011B%\t\rA;\u0001\u0015!\u0003K\u0011\u001d\tvA1A\u0005\u0002ICaaV\u0004!\u0002\u0013\u0019\u0006b\u0002-\b\u0005\u0004%I!\u0017\u0005\u0007K\u001e\u0001\u000b\u0011\u0002.\t\u000f\u0019<!\u0019!C\u0005O\"9\u0011\u0011B\u0004!\u0002\u0013A\u0007\"CA\u0006\u000f\t\u0007I\u0011BA\u0007\u0011!\t\tc\u0002Q\u0001\n\u0005=\u0001bBA\u0012\u000f\u0011%\u0011Q\u0005\u0005\b\u0003[9A\u0011AA\u0018\u0011\u001d\tic\u0002C\u0001\u0003+Bq!!\u0019\b\t\u0003\t\u0019\u0007C\u0004\u0002b\u001d!\t!a\u001a\t\u000f\u0005-t\u0001\"\u0003\u0002n!9\u0011\u0011O\u0004\u0005\u0002\u0005M\u0004bBAG\u000f\u0011%\u0011qR\u0001\u0010!\u0016\\7n\\'b]\u0006<W-\\3oi*\u0011q\u0004I\u0001\tg\u000e\fG.\u00193tY*\u0011\u0011EI\u0001\u000b[\u0006t\u0017mZ3nK:$(BA\u0012%\u0003\u0015\u0001Xm[6p\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001A\u0011!&A\u0007\u0002=\ty\u0001+Z6l_6\u000bg.Y4f[\u0016tGoE\u0003\u0002[M\n\t\n\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VM\u001a\t\u0004i]JT\"A\u001b\u000b\u0005Y\u0012\u0013!B1di>\u0014\u0018B\u0001\u001d6\u0005-)\u0005\u0010^3og&|g.\u00133\u0011\u0005):1cA\u0004.wA\u0011A\u0007P\u0005\u0003{U\u0012\u0011\"\u0012=uK:\u001c\u0018n\u001c8\u0002\rML8\u000f^3n+\u0005\u0001\u0005C\u0001\u001bB\u0013\t\u0011UGA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0002\rqJg.\u001b;?)\u00051ECA\u001dH\u0011\u0015q$\u0002q\u0001A\u0003\rawnZ\u000b\u0002\u0015B\u00111JT\u0007\u0002\u0019*\u0011QJI\u0001\u0006KZ,g\u000e^\u0005\u0003\u001f2\u0013A#T1sW\u0016\u0014Hj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\n\u0001b]3ui&twm]\u000b\u0002'B\u0011A+V\u0007\u0002A%\u0011a\u000b\t\u0002\u0018!\u0016\\7n\\'b]\u0006<W-\\3oiN+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\u001dI|W\u000f^3Qe>4\u0018\u000eZ3sgV\t!\fE\u0002\\A\nl\u0011\u0001\u0018\u0006\u0003;z\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005}{\u0013AC2pY2,7\r^5p]&\u0011\u0011\r\u0018\u0002\u0004'\u0016\f\bC\u0001\u0016d\u0013\t!gDA\fNC:\fw-Z7f]R\u0014v.\u001e;f!J|g/\u001b3fe\u0006y!o\\;uKB\u0013xN^5eKJ\u001c\b%A\u0007cS:$\u0017N\\4GkR,(/Z\u000b\u0002QB\u0019\u0011N\u001d;\u000e\u0003)T!a\u001b7\u0002\r\u0005$x.\\5d\u0015\tig.\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u001c9\u0002\tU$\u0018\u000e\u001c\u0006\u0002c\u0006!!.\u0019<b\u0013\t\u0019(NA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\r)x/_\u0007\u0002m*\u0011QnL\u0005\u0003qZ\u0014aAR;ukJ,\u0007c\u0001>\u0002\u00049\u00111p`\u0007\u0002y*\u0011q$ \u0006\u0003}\n\nA\u0001\u001b;ua&\u0019\u0011\u0011\u0001?\u0002\t!#H\u000f]\u0005\u0005\u0003\u000b\t9AA\u0007TKJ4XM\u001d\"j]\u0012Lgn\u001a\u0006\u0004\u0003\u0003a\u0018A\u00042j]\u0012Lgn\u001a$viV\u0014X\rI\u0001\u000fg\u0016dg-\u0016:j!J|W.[:f+\t\ty\u0001E\u0003v\u0003#\t)\"C\u0002\u0002\u0014Y\u0014q\u0001\u0015:p[&\u001cX\r\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\u0002`\u0001\u0006[>$W\r\\\u0005\u0005\u0003?\tIBA\u0002Ve&\fqb]3mMV\u0013\u0018\u000e\u0015:p[&\u001cX\rI\u0001\u0011aJ|g/\u001b3feN+G\u000f^5oON,\"!a\n\u0011\u0007)\nI#C\u0002\u0002,y\u0011q$T1oC\u001e,W.\u001a8u%>,H/\u001a)s_ZLG-\u001a:TKR$\u0018N\\4t\u0003\u0019\u0011x.\u001e;fgV\u0011\u0011\u0011\u0007\t\u0005\u0003g\tyE\u0004\u0003\u00026\u0005%c\u0002BA\u001c\u0003\u000brA!!\u000f\u0002D9!\u00111HA!\u001d\u0011\ti$a\u0010\u000e\u0003\u0011J!a\t\u0013\n\u0005y\u0014\u0013BA\u0010~\u0013\r\t9\u0005`\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005-\u0013QJ\u0001\ba\u0006\u001c7.Y4f\u0015\r\t9\u0005`\u0005\u0005\u0003#\n\u0019FA\u0003S_V$XM\u0003\u0003\u0002L\u00055C\u0003BA\u0019\u0003/Bq!!\u0017\u0018\u0001\u0004\tY&A\tue\u0006t7OZ8s[N+G\u000f^5oON\u0004rALA/\u0003O\t9#C\u0002\u0002`=\u0012\u0011BR;oGRLwN\\\u0019\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005\u0015\u0004\u0003B;x\u0003+!B!!\u001a\u0002j!9\u0011\u0011L\rA\u0002\u0005m\u0013!\u00069sKB\f'/Z\"p[\nLg.\u001a3S_V$Xm\u001d\u000b\u0005\u0003c\ty\u0007C\u0004\u0002$i\u0001\r!a\n\u0002\tM$x\u000e\u001d\u000b\u0003\u0003k\u0002B!^<\u0002xA!\u0011\u0011PA>\u001b\u0005\u0011\u0013bAA?E\t!Ai\u001c8fQ\rY\u0012\u0011\u0011\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011qQ\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\f\u0006\u0015%a\u0002;bS2\u0014XmY\u0001\u0013Y>\fGMU8vi\u0016\u0004&o\u001c<jI\u0016\u00148\u000fF\u0001[!\r!\u00141S\u0005\u0004\u0003++$aE#yi\u0016t7/[8o\u0013\u0012\u0004&o\u001c<jI\u0016\u0014H#A\u0015\u0002\r1|wn[;q+\t\tiJ\u0004\u0002+\u0001\u0005\u0019q-\u001a;\u0015\u0007e\n\u0019\u000b\u0003\u0004?\t\u0001\u0007\u0011Q\u0015\t\u0004i\u0005\u001d\u0016bAAUk\tY\u0011i\u0019;peNK8\u000f^3n)\rI\u0014Q\u0016\u0005\u0007}\u0015\u0001\r!a,\u0011\u0007Q\n\t,C\u0002\u00024V\u0012!d\u00117bgNL7-Q2u_J\u001c\u0016p\u001d;f[B\u0013xN^5eKJ\fqb\u0019:fCR,W\t\u001f;f]NLwN\u001c\u000b\u0004s\u0005e\u0006\"\u0002 \u0007\u0001\u0004\u0001\u0005")
public final class PekkoManagement
implements Extension {
    private final ExtendedActorSystem system;
    private final MarkerLoggingAdapter log;
    private final PekkoManagementSettings settings;
    private final Seq<ManagementRouteProvider> routeProviders;
    private final AtomicReference<Future<Http.ServerBinding>> bindingFuture;
    private final Promise<Uri> selfUriPromise;

    public static PekkoManagement createExtension(ExtendedActorSystem system) {
        return new PekkoManagement(system);
    }

    public static PekkoManagement get(ClassicActorSystemProvider system) {
        return (PekkoManagement)ExtensionId.get$((ExtensionId)PekkoManagement$.MODULE$, (ClassicActorSystemProvider)system);
    }

    public static PekkoManagement get(ActorSystem system) {
        return (PekkoManagement)ExtensionId.get$((ExtensionId)PekkoManagement$.MODULE$, (ActorSystem)system);
    }

    public static PekkoManagement$ lookup() {
        return PekkoManagement$.MODULE$;
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return ExtensionId.apply$((ExtensionId)PekkoManagement$.MODULE$, (ClassicActorSystemProvider)system);
    }

    public static Extension apply(ActorSystem system) {
        return ExtensionId.apply$((ExtensionId)PekkoManagement$.MODULE$, (ActorSystem)system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private MarkerLoggingAdapter log() {
        return this.log;
    }

    public PekkoManagementSettings settings() {
        return this.settings;
    }

    private Seq<ManagementRouteProvider> routeProviders() {
        return this.routeProviders;
    }

    private AtomicReference<Future<Http.ServerBinding>> bindingFuture() {
        return this.bindingFuture;
    }

    private Promise<Uri> selfUriPromise() {
        return this.selfUriPromise;
    }

    private ManagementRouteProviderSettings providerSettings() {
        String protocol = "http";
        String host = this.settings().Http().Hostname();
        int port = this.settings().Http().Port();
        String path = (String)this.settings().Http().BasePath().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)x$1 -> new StringBuilder(1).append("/").append((String)x$1).toString());
        String x$5 = Uri$.MODULE$.from$default$2();
        Option x$6 = Uri$.MODULE$.from$default$6();
        Option x$7 = Uri$.MODULE$.from$default$7();
        Uri.ParsingMode x$8 = Uri$.MODULE$.from$default$8();
        Uri selfBaseUri = Uri$.MODULE$.from(protocol, x$5, host, port, path, x$6, x$7, x$8);
        boolean apply_readOnly = this.settings().Http().RouteProvidersReadOnly();
        return new ManagementRouteProviderSettingsImpl(selfBaseUri, (Option<Function1<Credentials, Future<Option<String>>>>)None$.MODULE$, (Option<Function<Optional<SecurityDirectives.ProvidedCredentials>, CompletionStage<Optional<String>>>>)None$.MODULE$, (Option<HttpsConnectionContext>)None$.MODULE$, apply_readOnly);
    }

    public Function1<RequestContext, Future<RouteResult>> routes() {
        return this.prepareCombinedRoutes(this.providerSettings());
    }

    public Function1<RequestContext, Future<RouteResult>> routes(Function1<ManagementRouteProviderSettings, ManagementRouteProviderSettings> transformSettings) {
        return this.prepareCombinedRoutes((ManagementRouteProviderSettings)transformSettings.apply((Object)this.providerSettings()));
    }

    public Future<Uri> start() {
        Promise start_serverBindingPromise = Promise$.MODULE$.apply();
        if (this.bindingFuture().compareAndSet(null, (Future<Http.ServerBinding>)start_serverBindingPromise.future())) {
            try {
                ServerBuilder serverBuilder;
                String start_effectiveBindHostname = this.settings().Http().EffectiveBindHostname();
                int start_effectiveBindPort = this.settings().Http().EffectiveBindPort();
                ManagementRouteProviderSettings managementRouteProviderSettings = this.providerSettings();
                ManagementRouteProviderSettings start_effectiveProviderSettings = (ManagementRouteProviderSettings)Predef$.MODULE$.identity((Object)managementRouteProviderSettings);
                this.log().info("Binding Pekko Management (HTTP) endpoint to: {}:{}", (Object)start_effectiveBindHostname, (Object)BoxesRunTime.boxToInteger((int)start_effectiveBindPort));
                Function1<RequestContext, Future<RouteResult>> start_combinedRoutes = this.prepareCombinedRoutes(start_effectiveProviderSettings);
                ServerBuilder start_baseBuilder = Http$.MODULE$.apply((ClassicActorSystemProvider)this.system()).newServerAt(start_effectiveBindHostname, start_effectiveBindPort).withSettings(((ServerSettings)ServerSettings$.MODULE$.apply((ActorSystem)this.system())).withRemoteAddressHeader(true));
                Option<HttpsConnectionContext> option = start_effectiveProviderSettings.httpsConnectionContext();
                if (option instanceof Some) {
                    HttpsConnectionContext start_httpsContext = (HttpsConnectionContext)((Some)option).value();
                    serverBuilder = start_baseBuilder.enableHttps(start_httpsContext);
                } else if (None$.MODULE$.equals(option)) {
                    serverBuilder = start_baseBuilder;
                } else {
                    throw new MatchError(option);
                }
                Future start_serverFutureBinding = serverBuilder.bind(RouteResult$.MODULE$.routeToFunction(start_combinedRoutes, (ClassicActorSystemProvider)this.system()));
                return start_serverBindingPromise.completeWith(start_serverFutureBinding).future().flatMap((Function1 & Serializable)binding -> {
                    int boundPort = binding.localAddress().getPort();
                    this.log().info(ManagementLogMarker$.MODULE$.boundHttp(new StringBuilder(1).append(start_effectiveBindHostname).append(":").append(boundPort).toString()), "Bound Pekko Management (HTTP) endpoint to: {}:{}", (Object)start_effectiveBindHostname, (Object)BoxesRunTime.boxToInteger((int)boundPort));
                    return this.selfUriPromise().success((Object)start_effectiveProviderSettings.selfBaseUri().withPort(boundPort)).future();
                }, (ExecutionContext)this.system().dispatcher());
            }
            catch (Throwable throwable) {
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    this.log().warning(throwable.getMessage());
                    return Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Failed to start Pekko Management HTTP endpoint.", throwable));
                }
                throw throwable;
            }
        }
        return this.selfUriPromise().future();
    }

    public Future<Uri> start(Function1<ManagementRouteProviderSettings, ManagementRouteProviderSettings> transformSettings) {
        Promise serverBindingPromise = Promise$.MODULE$.apply();
        if (this.bindingFuture().compareAndSet(null, (Future<Http.ServerBinding>)serverBindingPromise.future())) {
            try {
                ServerBuilder serverBuilder;
                String effectiveBindHostname = this.settings().Http().EffectiveBindHostname();
                int effectiveBindPort = this.settings().Http().EffectiveBindPort();
                ManagementRouteProviderSettings effectiveProviderSettings = (ManagementRouteProviderSettings)transformSettings.apply((Object)this.providerSettings());
                this.log().info("Binding Pekko Management (HTTP) endpoint to: {}:{}", (Object)effectiveBindHostname, (Object)BoxesRunTime.boxToInteger((int)effectiveBindPort));
                Function1<RequestContext, Future<RouteResult>> combinedRoutes = this.prepareCombinedRoutes(effectiveProviderSettings);
                ServerBuilder baseBuilder = Http$.MODULE$.apply((ClassicActorSystemProvider)this.system()).newServerAt(effectiveBindHostname, effectiveBindPort).withSettings(((ServerSettings)ServerSettings$.MODULE$.apply((ActorSystem)this.system())).withRemoteAddressHeader(true));
                Option<HttpsConnectionContext> option = effectiveProviderSettings.httpsConnectionContext();
                if (option instanceof Some) {
                    HttpsConnectionContext httpsContext = (HttpsConnectionContext)((Some)option).value();
                    serverBuilder = baseBuilder.enableHttps(httpsContext);
                } else if (None$.MODULE$.equals(option)) {
                    serverBuilder = baseBuilder;
                } else {
                    throw new MatchError(option);
                }
                Future serverFutureBinding = serverBuilder.bind(RouteResult$.MODULE$.routeToFunction(combinedRoutes, (ClassicActorSystemProvider)this.system()));
                return serverBindingPromise.completeWith(serverFutureBinding).future().flatMap((Function1 & Serializable)binding -> {
                    int boundPort = binding.localAddress().getPort();
                    this.log().info(ManagementLogMarker$.MODULE$.boundHttp(new StringBuilder(1).append(start_effectiveBindHostname).append(":").append(boundPort).toString()), "Bound Pekko Management (HTTP) endpoint to: {}:{}", (Object)start_effectiveBindHostname, (Object)BoxesRunTime.boxToInteger((int)boundPort));
                    return this.selfUriPromise().success((Object)start_effectiveProviderSettings.selfBaseUri().withPort(boundPort)).future();
                }, (ExecutionContext)this.system().dispatcher());
            }
            catch (Throwable throwable) {
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    this.log().warning(throwable.getMessage());
                    return Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Failed to start Pekko Management HTTP endpoint.", throwable));
                }
                throw throwable;
            }
        }
        return this.selfUriPromise().future();
    }

    private Function1<RequestContext, Future<RouteResult>> prepareCombinedRoutes(ManagementRouteProviderSettings providerSettings) {
        String pathPrefixName = (String)this.settings().Http().BasePath().getOrElse((Function0 & Serializable)() -> "");
        Directive basePath = pathPrefixName.isEmpty() ? Directives$.MODULE$.rawPathPrefix(PathMatcher$.MODULE$._segmentStringToPathMatcher(pathPrefixName)) : Directives$.MODULE$.pathPrefix(PathMatchers$.MODULE$.separateOnSlashes(pathPrefixName));
        Seq combinedRoutes = (Seq)this.routeProviders().map((Function1 & Serializable)provider -> {
            this.log().info("Including HTTP management routes for {}", (Object)Logging$.MODULE$.simpleName(provider));
            return provider.routes(providerSettings);
        });
        if (combinedRoutes.nonEmpty()) {
            return (Function1)Directive$.MODULE$.addByNameNullaryApply(basePath).apply((Function0 & Serializable)() -> this.wrapWithAuthenticatorIfPresent$1(Directives$.MODULE$.concat(combinedRoutes), providerSettings));
        }
        throw new IllegalArgumentException("No routes configured for pekko management! Double check your `pekko.management.http.routes` config.");
    }

    public Future<Done> stop() {
        Future<Http.ServerBinding> binding;
        do {
            if ((binding = this.bindingFuture().get()) != null) continue;
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        } while (!this.bindingFuture().compareAndSet(binding, null));
        return binding.flatMap((Function1 & Serializable)x$5 -> x$5.unbind(), (ExecutionContext)this.system().dispatcher()).map((Function1 & Serializable)x$6 -> Done$.MODULE$, (ExecutionContext)this.system().dispatcher());
    }

    private Seq<ManagementRouteProvider> loadRouteProviders() {
        DynamicAccess dynamicAccess = this.system().dynamicAccess();
        return (Seq)this.settings().Http().RouteProviders().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Object provider;
                Object provider2;
                String name = x0$1.name();
                String fqcn = x0$1.fullyQualifiedClassName();
                boolean bl = false;
                Success success = null;
                Try try_ = dynamicAccess.getObjectFor(fqcn, ClassTag$.MODULE$.apply(ExtensionIdProvider.class)).recoverWith((PartialFunction)new Serializable(null, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ExtensionIdProvider.class));
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        return true;
                    }
                    {
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                }).recoverWith((PartialFunction)new Serializable(this, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ PekkoManagement $outer;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        if (x2 instanceof ClassCastException ? true : x2 instanceof NoSuchMethodException) {
                            Tuple2 tuple2 = new Tuple2(ExtendedActorSystem.class, (Object)this.$outer.system());
                            return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$.$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(ExtensionIdProvider.class));
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(Throwable x2) {
                        return x2 instanceof ClassCastException ? true : x2 instanceof NoSuchMethodException;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                }).recoverWith((PartialFunction)new Serializable(null, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        if (x3 instanceof ClassCastException ? true : x3 instanceof NoSuchMethodException) {
                            return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ManagementRouteProvider.class));
                        }
                        return (B1)function1.apply(x3);
                    }

                    public final boolean isDefinedAt(Throwable x3) {
                        return x3 instanceof ClassCastException ? true : x3 instanceof NoSuchMethodException;
                    }
                    {
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                }).recoverWith((PartialFunction)new Serializable(this, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ PekkoManagement $outer;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                        if (x4 instanceof ClassCastException ? true : x4 instanceof NoSuchMethodException) {
                            Tuple2 tuple2 = new Tuple2(ExtendedActorSystem.class, (Object)this.$outer.system());
                            return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$.$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(ManagementRouteProvider.class));
                        }
                        return (B1)function1.apply(x4);
                    }

                    public final boolean isDefinedAt(Throwable x4) {
                        return x4 instanceof ClassCastException ? true : x4 instanceof NoSuchMethodException;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                }).recoverWith((PartialFunction)new Serializable(null, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                        if (x5 instanceof ClassCastException ? true : x5 instanceof NoSuchMethodException) {
                            return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(org.apache.pekko.management.javadsl.ManagementRouteProvider.class));
                        }
                        return (B1)function1.apply(x5);
                    }

                    public final boolean isDefinedAt(Throwable x5) {
                        return x5 instanceof ClassCastException ? true : x5 instanceof NoSuchMethodException;
                    }
                    {
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                }).recoverWith((PartialFunction)new Serializable(this, dynamicAccess, fqcn){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ PekkoManagement $outer;
                    private final DynamicAccess dynamicAccess$1;
                    private final String fqcn$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                        if (x6 instanceof ClassCastException ? true : x6 instanceof NoSuchMethodException) {
                            Tuple2 tuple2 = new Tuple2(ExtendedActorSystem.class, (Object)this.$outer.system());
                            return (B1)this.dynamicAccess$1.createInstanceFor(this.fqcn$1, (Seq)Nil$.MODULE$.$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(org.apache.pekko.management.javadsl.ManagementRouteProvider.class));
                        }
                        return (B1)function1.apply(x6);
                    }

                    public final boolean isDefinedAt(Throwable x6) {
                        return x6 instanceof ClassCastException ? true : x6 instanceof NoSuchMethodException;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dynamicAccess$1 = dynamicAccess$1;
                        this.fqcn$1 = fqcn$1;
                    }
                });
                if (try_ instanceof Success) {
                    bl = true;
                    success = (Success)try_;
                    Object p = success.value();
                    if (p instanceof ExtensionIdProvider) {
                        ExtensionIdProvider extensionIdProvider = (ExtensionIdProvider)p;
                        Extension extension = this.system().registerExtension(extensionIdProvider.lookup());
                        if (extension instanceof ManagementRouteProvider) {
                            return (ManagementRouteProvider)extension;
                        }
                        if (extension instanceof org.apache.pekko.management.javadsl.ManagementRouteProvider) {
                            org.apache.pekko.management.javadsl.ManagementRouteProvider managementRouteProvider = (org.apache.pekko.management.javadsl.ManagementRouteProvider)extension;
                            return new ManagementRouteProviderAdapter(managementRouteProvider);
                        }
                        throw new RuntimeException(new StringBuilder(65).append("Extension [").append(fqcn).append("] should create a 'ManagementRouteProvider' but was ").append("[").append(extension.getClass().getName()).append("]").toString());
                    }
                }
                if (bl && (provider2 = success.value()) instanceof ManagementRouteProvider) {
                    return (ManagementRouteProvider)provider2;
                }
                if (bl && (provider = success.value()) instanceof org.apache.pekko.management.javadsl.ManagementRouteProvider) {
                    org.apache.pekko.management.javadsl.ManagementRouteProvider managementRouteProvider = (org.apache.pekko.management.javadsl.ManagementRouteProvider)provider;
                    return new ManagementRouteProviderAdapter(managementRouteProvider);
                }
                if (bl) {
                    throw new RuntimeException(new StringBuilder(78).append("[").append(fqcn).append("] is not an 'ExtensionIdProvider', 'ExtensionId' or 'ManagementRouteProvider'").toString());
                }
                if (try_ instanceof Failure) {
                    Throwable problem = ((Failure)try_).exception();
                    throw new RuntimeException(new StringBuilder(51).append("While trying to load route provider extension [").append(name).append(" = ").append(fqcn).append("]").toString(), problem);
                }
                throw new MatchError((Object)try_);
            }
            throw new MatchError(null);
        });
    }

    public static final /* synthetic */ ManagementRouteProviderSettings $anonfun$start$1(ManagementRouteProviderSettings x) {
        return (ManagementRouteProviderSettings)Predef$.MODULE$.identity((Object)x);
    }

    private static final Optional credsToJava$1(Credentials cred) {
        if (cred instanceof Credentials.Provided) {
            Credentials.Provided provided = (Credentials.Provided)cred;
            return Optional.of(new SecurityDirectives.ProvidedCredentials(provided));
        }
        return Optional.empty();
    }

    private final Function1 wrapWithAuthenticatorIfPresent$1(Function1 inner, ManagementRouteProviderSettings providerSettings$1) {
        ManagementRouteProviderSettingsImpl providerSettingsImpl = (ManagementRouteProviderSettingsImpl)providerSettings$1;
        Option<Function<Optional<SecurityDirectives.ProvidedCredentials>, CompletionStage<Optional<String>>>> option = providerSettingsImpl.javadslAuth();
        Option<Function1<Credentials, Future<Option<String>>>> option2 = providerSettingsImpl.scaladslAuth();
        Tuple2 tuple2 = new Tuple2(option2, option);
        if (None$.MODULE$.equals(option2) && None$.MODULE$.equals(option)) {
            return inner;
        }
        if (option2 instanceof Some) {
            Function1 asyncAuthenticator = (Function1)((Some)option2).value();
            if (None$.MODULE$.equals(option)) {
                return (Function1)Directive$.MODULE$.addDirectiveApply((Directive)Directives$.MODULE$.authenticateBasicAsync("secured", asyncAuthenticator), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x$2 -> inner);
            }
        }
        if (None$.MODULE$.equals(option2) && option instanceof Some) {
            Function auth = (Function)((Some)option).value();
            return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.authenticateBasicAsync("secured", (Function1 & Serializable)c -> {
                CompletionStage CompletionStageOps_cs = (CompletionStage)auth.apply(PekkoManagement.credsToJava$1(c));
                Object var4_3 = null;
                CompletionStage asScala$extension_$this = CompletionStageOps_cs;
                Object var3_4 = null;
                return FutureConverters$.MODULE$.asScala(asScala$extension_$this).map((Function1 & Serializable)x$3 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(x$3)), (ExecutionContext)this.system().dispatcher());
            }).optional(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x$4 -> inner);
        }
        if (option2 instanceof Some && option instanceof Some) {
            throw new IllegalStateException("Unexpected that both scaladsl and javadsl auth were defined");
        }
        throw new MatchError((Object)tuple2);
    }

    public PekkoManagement(ExtendedActorSystem system) {
        this.system = system;
        ((ManifestInfo)ManifestInfo$.MODULE$.apply((ActorSystem)system)).checkSameVersion("Pekko Management", (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pekko-discovery-consul", "pekko-discovery-aws-api", "pekko-discovery-marathon-api", "pekko-discovery-aws-api-async", "pekko-discovery-kubernetes-api", "pekko-lease-kubernetes", "pekko-management", "pekko-management-cluster-bootstrap", "pekko-management-cluster-http"})), true);
        this.log = Logging$.MODULE$.withMarker((ActorSystem)system, this.getClass(), LogSource$.MODULE$.fromClass());
        this.settings = new PekkoManagementSettings(system.settings().config());
        this.routeProviders = this.loadRouteProviders();
        this.bindingFuture = new AtomicReference();
        this.selfUriPromise = Promise$.MODULE$.apply();
    }
}

