/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.util.rs;

import com.cyberark.conjur.api.AuthnProvider;
import com.cyberark.conjur.api.Token;
import com.cyberark.conjur.util.Args;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;

public class TokenAuthFilter
implements ClientRequestFilter {
    private static final int EXPIRATION_TIME_BUFFER = 120;
    private static final String HEADER = "Authorization";
    private final AuthnProvider authn;
    private Token currentToken;

    public TokenAuthFilter(AuthnProvider authn) {
        this.authn = Args.notNull(authn);
    }

    public void filter(ClientRequestContext rc) throws IOException {
        if (!this.isTokenValid()) {
            this.currentToken = this.authn.authenticate();
        }
        rc.getHeaders().putSingle((Object)HEADER, (Object)this.currentToken.toHeader());
    }

    private boolean isTokenValid() {
        return this.currentToken != null && !this.currentToken.willExpireWithin(120);
    }
}

