/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.util.List;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.internal.AbstractServiceRegistryImpl;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.hibernate.service.spi.SessionFactoryServiceInitiatorContext;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;

public class SessionFactoryServiceRegistryImpl
extends AbstractServiceRegistryImpl
implements SessionFactoryServiceRegistry,
SessionFactoryServiceInitiatorContext {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = Logger.getLogger(SessionFactoryServiceRegistryImpl.class);
    private final @UnknownKeyFor @NonNull @Initialized SessionFactoryOptions sessionFactoryOptions;
    private final @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory;

    private SessionFactoryServiceRegistryImpl(@UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor parent, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory, @UnknownKeyFor @NonNull @Initialized SessionFactoryOptions sessionFactoryOptions) {
        super(parent);
        this.sessionFactory = sessionFactory;
        this.sessionFactoryOptions = sessionFactoryOptions;
    }

    public static @UnknownKeyFor @NonNull @Initialized SessionFactoryServiceRegistryImpl create(@UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor parent, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SessionFactoryServiceInitiator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> initiators, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ProvidedService<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> providedServices, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory, @UnknownKeyFor @NonNull @Initialized SessionFactoryOptions sessionFactoryOptions) {
        SessionFactoryServiceRegistryImpl instance = new SessionFactoryServiceRegistryImpl(parent, sessionFactory, sessionFactoryOptions);
        instance.initialize(initiators, providedServices);
        return instance;
    }

    protected void initialize(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SessionFactoryServiceInitiator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> initiators, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ProvidedService<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> providedServices) {
        super.initialize();
        for (SessionFactoryServiceInitiator<?> sessionFactoryServiceInitiator : initiators) {
            this.createServiceBinding(sessionFactoryServiceInitiator);
        }
        for (ProvidedService providedService : providedServices) {
            this.createServiceBinding(providedService);
        }
    }

    @Override
    public <R extends Service> R initiateService(@UnknownKeyFor @NonNull @Initialized ServiceInitiator<R> serviceInitiator) {
        SessionFactoryServiceInitiator sessionFactoryServiceInitiator = (SessionFactoryServiceInitiator)serviceInitiator;
        return sessionFactoryServiceInitiator.initiateService(this);
    }

    @Override
    public <R extends Service> void configureService(@UnknownKeyFor @NonNull @Initialized ServiceBinding<R> serviceBinding) {
        if (serviceBinding.getService() instanceof Configurable) {
            ((Configurable)serviceBinding.getService()).configure(this.requireService(ConfigurationService.class).getSettings());
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionFactoryOptions getSessionFactoryOptions() {
        return this.sessionFactoryOptions;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor getServiceRegistry() {
        return this;
    }

    @Override
    public <R extends Service> @Nullable R getService(@UnknownKeyFor @NonNull @Initialized Class<R> serviceRole) {
        if (serviceRole.equals(EventListenerRegistry.class)) {
            log.debug((Object)"EventListenerRegistry access via ServiceRegistry is deprecated.  Use `sessionFactory.getEventEngine().getListenerRegistry()` instead");
            return (R)this.sessionFactory.getEventEngine().getListenerRegistry();
        }
        return super.getService(serviceRole);
    }
}

