/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springboot;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import org.jboss.resteasy.plugins.server.servlet.ListenerBootstrap;
import org.jboss.resteasy.plugins.spring.SpringBeanProcessor;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.springboot.ResteasyApplicationBuilder;
import org.jboss.resteasy.springboot.ResteasyBeanProcessorTomcat;
import org.jboss.resteasy.springboot.common.DeploymentCustomizer;
import org.jboss.resteasy.springboot.common.ResteasyBeanProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties
public class ResteasyAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(ResteasyAutoConfiguration.class);

    @Bean
    public ServletContextListener resteasyBootstrapListener(final @Qualifier(value="resteasySpringBeanProcessor") SpringBeanProcessor resteasySpringBeanProcessor) {
        ServletContextListener servletContextListener = new ServletContextListener(){
            protected ResteasyDeployment deployment;

            public void contextInitialized(ServletContextEvent sce) {
                ServletContext servletContext = sce.getServletContext();
                this.deployment = new ListenerBootstrap(servletContext).createDeployment();
                DeploymentCustomizer.customizeRestEasyDeployment((SpringBeanProcessor)resteasySpringBeanProcessor, (ResteasyDeployment)this.deployment, (boolean)this.deployment.isAsyncJobServiceEnabled());
                this.deployment.start();
                servletContext.setAttribute(ResteasyProviderFactory.class.getName(), (Object)this.deployment.getProviderFactory());
                servletContext.setAttribute(Dispatcher.class.getName(), (Object)this.deployment.getDispatcher());
                servletContext.setAttribute(Registry.class.getName(), (Object)this.deployment.getRegistry());
            }

            public void contextDestroyed(ServletContextEvent sce) {
                if (this.deployment != null) {
                    this.deployment.stop();
                }
            }
        };
        logger.debug("ServletContextListener has been created");
        return servletContextListener;
    }

    @Bean(name={"JaxrsApplicationServletBuilder"})
    public ResteasyApplicationBuilder resteasyApplicationBuilder() {
        return new ResteasyApplicationBuilder();
    }

    @Bean
    public static ResteasyBeanProcessorTomcat resteasyBeanProcessorTomcat() {
        return new ResteasyBeanProcessorTomcat();
    }

    @Bean(value={"resteasySpringBeanProcessor"})
    public static SpringBeanProcessor resteasySpringBeanProcessor() {
        return ResteasyBeanProcessorFactory.resteasySpringBeanProcessor();
    }
}

