/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.DatesForm;
import com.xebialabs.xlrelease.views.LinkForm;
import com.xebialabs.xlrelease.views.LinkView;
import com.xebialabs.xlrelease.views.converters.DurationViewConverter;
import io.micrometer.core.annotation.Timed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/planning")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class PlanningResource {
    private PermissionChecker permissionChecker;
    private ReleaseActorService releaseActorService;

    @Autowired
    public PlanningResource(PermissionChecker permissionChecker, ReleaseActorService releaseActorService) {
        this.releaseActorService = releaseActorService;
        this.permissionChecker = permissionChecker;
    }

    @PUT
    @Timed
    @Path(value="{planItemId:.*(Release|Phase|Task)[^/-]*}")
    public void updateDates(@PathParam(value="planItemId") @IdParam String planItemId, DatesForm datesForm) {
        this.permissionChecker.checkEditDate(planItemId);
        this.releaseActorService.updateDates(planItemId, datesForm.getScheduledStartDate(), datesForm.getDueDate(), DurationViewConverter.fromDurationView(datesForm.getPlannedDuration()));
    }

    @POST
    @Timed
    @Path(value="links/{containerId:.*Task[^/-]*}")
    public LinkView addLink(@PathParam(value="containerId") @IdParam String containerId, LinkForm linkForm) {
        this.permissionChecker.checkEdit(Ids.releaseIdFrom((String)containerId));
        return new LinkView(this.releaseActorService.createLink(containerId, linkForm.getSourceId(), linkForm.getTargetId()));
    }

    @DELETE
    @Timed
    @Path(value="links/{linkId:.*Link[^/-]*}")
    public void removeLink(@PathParam(value="linkId") @IdParam String linkId) {
        this.permissionChecker.checkEdit(Ids.releaseIdFrom((String)linkId));
        this.releaseActorService.deleteLink(linkId);
    }
}

