/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.config;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArchivingSettingsManager {
    private static final Logger logger = LoggerFactory.getLogger(ArchivingSettingsManager.class);
    private final ConfigurationRepository configurationRepository;
    private Boolean preArchivingEnabled;
    private Boolean enabled;
    private Integer searchPageSize;
    private Integer maxSecondsPerRun;
    private Integer sleepSecondsBetweenReleases;
    private Integer purgingSearchPageSize;
    private Integer purgingMaxSecondsPerRun;
    private Integer purgingSleepSecondsBetweenReleases;
    private Integer releaseCleanupSleepSecondsBetweenAbort;
    private Integer releaseCleanupSearchPageSize;
    private Integer releaseCleanupMaxSecondsPerRun;
    private Consumer<Boolean> preArchivingEnabledChangedCallback;

    @Autowired
    public ArchivingSettingsManager(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        ArchivingSettings defaults = (ArchivingSettings)Type.valueOf(ArchivingSettings.class).getDescriptor().newInstance("Configuration/settings/ArchivingSettings");
        this.preArchivingEnabled = defaults.getPreArchivingEnabled();
        this.enabled = defaults.getEnabled();
        this.searchPageSize = defaults.getSearchPageSize();
        this.maxSecondsPerRun = defaults.getMaxSecondsPerRun();
        this.sleepSecondsBetweenReleases = defaults.getSleepSecondsBetweenReleases();
        this.purgingMaxSecondsPerRun = defaults.getPurgingMaxSecondsPerRun();
        this.purgingSearchPageSize = defaults.getPurgingSearchPageSize();
        this.purgingSleepSecondsBetweenReleases = defaults.getPurgingSleepSecondsBetweenReleases();
        this.releaseCleanupSleepSecondsBetweenAbort = defaults.getReleaseCleanupSleepSecondsBetweenAbort();
        this.releaseCleanupSearchPageSize = defaults.getReleaseCleanupSearchPageSize();
        this.releaseCleanupMaxSecondsPerRun = defaults.getReleaseCleanupMaxSecondsPerRun();
    }

    public void subscribeToPreArchivingEnabledChanges(Consumer<Boolean> callback) {
        this.preArchivingEnabledChangedCallback = callback;
    }

    public boolean getPreArchivingEnabled() {
        return this.preArchivingEnabled;
    }

    public void setPreArchivingEnabled(Boolean enabled) {
        logger.info("Setting pre-archiving enabled to be {}", (Object)enabled);
        if (this.preArchivingEnabledChangedCallback != null && enabled != this.preArchivingEnabled) {
            this.preArchivingEnabledChangedCallback.accept(enabled);
        }
        this.preArchivingEnabled = enabled;
    }

    public Integer getReleaseAgeToDeleteFromJcr() {
        return this.getStoredArchivingSettings().getReleaseAgeToDeleteFromJcr();
    }

    public String getArchivingJobCronSchedule() {
        return this.getStoredArchivingSettings().getArchivingJobCronSchedule();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        logger.info("Setting archiving enabled to be {}", (Object)enabled);
        this.enabled = enabled;
    }

    public Integer getSearchPageSize() {
        return this.searchPageSize;
    }

    public void setSearchPageSize(Integer searchPageSize) {
        logger.info("Setting archiving search page size to be {}", (Object)searchPageSize);
        this.searchPageSize = searchPageSize;
    }

    public Integer getMaxSecondsPerRun() {
        return this.maxSecondsPerRun;
    }

    public void setMaxSecondsPerRun(Integer maxSecondsPerRun) {
        logger.info("Setting archiving max seconds per run to be {}", (Object)maxSecondsPerRun);
        this.maxSecondsPerRun = maxSecondsPerRun;
    }

    public Integer getSleepSecondsBetweenReleases() {
        return this.sleepSecondsBetweenReleases;
    }

    public void setSleepSecondsBetweenReleases(Integer sleepSecondsBetweenReleases) {
        logger.info("Setting archiving sleep seconds between releases to be {}", (Object)sleepSecondsBetweenReleases);
        this.sleepSecondsBetweenReleases = sleepSecondsBetweenReleases;
    }

    public Integer getMaximumArchiveRetentionPeriod() {
        return this.getStoredArchivingSettings().getMaximumArchiveRetentionPeriod();
    }

    public String getPurgingJobCronSchedule() {
        return this.getStoredArchivingSettings().getPurgingJobCronSchedule();
    }

    public boolean getPurgingEnabled() {
        return this.getStoredArchivingSettings().getPurgingEnabled();
    }

    public String getPurgeExportPath() {
        return this.getStoredArchivingSettings().getPurgeExportPath();
    }

    public boolean getExportOnPurgeEnabled() {
        return this.getStoredArchivingSettings().getExportOnPurgeEnabled();
    }

    public Integer getPurgingSearchPageSize() {
        return this.purgingSearchPageSize;
    }

    public void setPurgingSearchPageSize(Integer searchPageSize) {
        logger.info("Setting purging search page size to be {}", (Object)searchPageSize);
        this.purgingSearchPageSize = searchPageSize;
    }

    public Integer getPurgingMaxSecondsPerRun() {
        return this.purgingMaxSecondsPerRun;
    }

    public void setPurgingMaxSecondsPerRun(Integer maxSecondsPerRun) {
        logger.info("Setting purging max seconds per run to be {}", (Object)maxSecondsPerRun);
        this.purgingMaxSecondsPerRun = maxSecondsPerRun;
    }

    public Integer getPurgingSleepSecondsBetweenReleases() {
        return this.purgingSleepSecondsBetweenReleases;
    }

    public void setPurgingSleepSecondsBetweenReleases(Integer sleepSecondsBetweenReleases) {
        logger.info("Setting purging sleep seconds between releases to be {}", (Object)sleepSecondsBetweenReleases);
        this.purgingSleepSecondsBetweenReleases = sleepSecondsBetweenReleases;
    }

    public boolean getReleaseCleanupEnabled() {
        return this.getStoredArchivingSettings().isReleaseCleanupEnabled();
    }

    public Integer getReleaseAgeToAbort() {
        return this.getStoredArchivingSettings().getReleaseAgeToAbort();
    }

    public Integer getReleaseCleanupSleepSecondsBetweenAbort() {
        return this.releaseCleanupSleepSecondsBetweenAbort;
    }

    public void setReleaseCleanupSleepSecondsBetweenAbort(Integer period) {
        logger.info("Setting release cleanup sleep seconds between abort to be {}", (Object)period);
        this.releaseCleanupSleepSecondsBetweenAbort = period;
    }

    public Integer getReleaseCleanupSearchPageSize() {
        return this.releaseCleanupSearchPageSize;
    }

    public void setReleaseCleanupSearchPageSize(Integer searchPageSize) {
        logger.info("Setting release cleanup search page size to be {}", (Object)searchPageSize);
        this.releaseCleanupSearchPageSize = searchPageSize;
    }

    public Integer getReleaseCleanupMaxSecondsPerRun() {
        return this.releaseCleanupMaxSecondsPerRun;
    }

    public void setReleaseCleanupMaxSecondsPerRun(Integer maxSecondsPerRun) {
        logger.info("Setting release cleanup max seconds per run to be {}", (Object)maxSecondsPerRun);
        this.releaseCleanupMaxSecondsPerRun = maxSecondsPerRun;
    }

    public String getReleaseCleanupCronSchedule() {
        return this.getStoredArchivingSettings().getReleaseCleanupCronSchedule();
    }

    private ArchivingSettings getStoredArchivingSettings() {
        return (ArchivingSettings)this.configurationRepository.read("Configuration/settings/ArchivingSettings");
    }
}

