/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.configuration;

import com.xebialabs.xlrelease.config.XlrConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.stereotype.Component;

@Component
public class CsrfFilterPostProcessor
implements BeanPostProcessor,
Ordered {
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!XlrConfig.getInstance().server_http_csrf_enabled() && bean instanceof DefaultSecurityFilterChain) {
            DefaultSecurityFilterChain defaultSecurityFilterChain = (DefaultSecurityFilterChain)bean;
            defaultSecurityFilterChain.getFilters().removeIf(CsrfFilter.class::isInstance);
        }
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

