/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springboot.common;

import java.util.Objects;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.spring.SpringBeanProcessor;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class DeploymentCustomizer {
    public static void customizeRestEasyDeployment(SpringBeanProcessor resteasySpringBeanProcessor, ResteasyDeployment deployment, boolean enableAsyncJob) {
        Objects.requireNonNull(resteasySpringBeanProcessor);
        Objects.requireNonNull(deployment);
        ResteasyProviderFactory resteasyProviderFactory = resteasySpringBeanProcessor.getProviderFactory();
        ResourceMethodRegistry resourceMethodRegistry = (ResourceMethodRegistry)resteasySpringBeanProcessor.getRegistry();
        deployment.setProviderFactory(resteasyProviderFactory);
        deployment.setRegistry((Registry)resourceMethodRegistry);
        if (enableAsyncJob) {
            deployment.setAsyncJobServiceEnabled(true);
            AsynchronousDispatcher dispatcher = new AsynchronousDispatcher(resteasyProviderFactory, resourceMethodRegistry);
            deployment.setDispatcher((Dispatcher)dispatcher);
        } else {
            SynchronousDispatcher dispatcher = new SynchronousDispatcher(resteasyProviderFactory, resourceMethodRegistry);
            deployment.setDispatcher((Dispatcher)dispatcher);
        }
    }
}

