/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.web.authentication;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SpnegoEntryPoint
implements AuthenticationEntryPoint {
    private static final Log LOG = LogFactory.getLog(SpnegoEntryPoint.class);
    private final String forwardUrl;
    private final HttpMethod forwardMethod;
    private final boolean forward;

    public SpnegoEntryPoint() {
        this(null);
    }

    public SpnegoEntryPoint(String forwardUrl) {
        this(forwardUrl, null);
    }

    public SpnegoEntryPoint(String forwardUrl, HttpMethod forwardMethod) {
        if (StringUtils.hasText((String)forwardUrl)) {
            Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)forwardUrl), (String)"Forward url specified must be a valid forward URL");
            Assert.isTrue((!UrlUtils.isAbsoluteUrl((String)forwardUrl) ? 1 : 0) != 0, (String)"Forward url specified must not be absolute");
            this.forwardUrl = forwardUrl;
            this.forwardMethod = forwardMethod;
            this.forward = true;
        } else {
            this.forwardUrl = null;
            this.forwardMethod = null;
            this.forward = false;
        }
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException ex) throws IOException, ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Add header WWW-Authenticate:Negotiate to " + request.getRequestURL() + ", forward: " + (this.forward ? this.forwardUrl : "no")));
        }
        response.addHeader("WWW-Authenticate", "Negotiate");
        response.setStatus(401);
        if (this.forward) {
            RequestDispatcher dispatcher = request.getRequestDispatcher(this.forwardUrl);
            Object fwdRequest = this.forwardMethod != null ? new HttpServletRequestWrapper(request){

                public String getMethod() {
                    return SpnegoEntryPoint.this.forwardMethod.name();
                }
            } : request;
            dispatcher.forward((ServletRequest)fwdRequest, (ServletResponse)response);
        } else {
            response.flushBuffer();
        }
    }
}

