/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.facet;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.facet.FacetScope;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.variable.ValueWithInterpolation;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root=Metadata.ConfigurationItemRoot.APPLICATIONS, versioned=false, virtual=true, description="Base facet class used to augment other CIs (tasks only currently)")
public abstract class Facet
extends BaseConfigurationItem
implements VisitableItem {
    @Property(hidden=true, category="internal", description="CI kind to which the facet can be applied.", defaultValue="TASK")
    protected FacetScope scope = FacetScope.TASK;
    @Property(description="The ID of the CI that the facet is applied to.")
    private String targetId;
    @Property
    private Map<String, String> variableMapping = Maps.newHashMap();

    public FacetScope getScope() {
        return this.scope;
    }

    public void setScope(FacetScope scope) {
        this.scope = scope;
    }

    @PublicApiMember
    public String getTargetId() {
        return this.targetId;
    }

    @PublicApiMember
    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        visitor.visit(this);
    }

    public List<UsagePoint> getVariableUsages() {
        return this.getPropertiesWithVariables().stream().map(pd -> new PropertyUsagePoint((ConfigurationItem)this, pd.getName())).collect(Collectors.toList());
    }

    public Map<String, String> getVariableMapping() {
        return this.variableMapping;
    }

    public void setVariableMapping(Map<String, String> variableMapping) {
        this.variableMapping = variableMapping;
    }

    public Set<String> freezeVariables(Map<String, ValueWithInterpolation> variables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet unresolvedVariables = Sets.newHashSet();
        Collection<PropertyDescriptor> propertiesWithVariables = this.getPropertiesWithVariables();
        propertiesWithVariables.forEach(propertyDescriptor -> {
            Object value = this.getProperty(propertyDescriptor.getName());
            value = VariableHelper.replaceAllWithInterpolation(value, variables, unresolvedVariables, freezeEvenIfUnresolved);
            this.setProperty(propertyDescriptor.getName(), value);
        });
        if (!propertiesWithVariables.isEmpty()) {
            changes.update((ConfigurationItem)this);
        }
        return unresolvedVariables;
    }

    public Collection<PropertyDescriptor> getPropertiesWithVariables() {
        return this.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> "input".equals(pd.getCategory())).collect(Collectors.toList());
    }
}

