/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.runner;

import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlrelease.domain.runner.RemoteRunnerRegistrySettings;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=RunnerRegistrySettingsValidator.class, type="remoteRunnerRegistrySettings")
@Target(value={ElementType.TYPE})
@interface RegistrySettingsValidator {

    public static class RunnerRegistrySettingsValidator
    implements Validator<RemoteRunnerRegistrySettings> {
        public void validate(RemoteRunnerRegistrySettings remoteRunnerRegistrySettings, ValidationContext context) {
            ExtendedValidationContext extendedContext = (ExtendedValidationContext)context;
            Set mappings = remoteRunnerRegistrySettings.imageUrlMappings().entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toSet());
            for (String baseUrl : remoteRunnerRegistrySettings.getBaseUrls()) {
                boolean isValid = false;
                for (String mapping : mappings) {
                    if (!mapping.startsWith(baseUrl)) continue;
                    isValid = true;
                    break;
                }
                if (isValid) continue;
                extendedContext.error("Base URL '%s' must be an beginning of at least one image URL mapping", new Object[]{baseUrl});
            }
        }
    }
}

