/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.domain;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.domain.CiWithInternalMetadata;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.TenantAwareCi;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.repository.Ids;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

@Metadata(versioned=false, description="A dashboard with tiles displayed in XL Release UI")
public class Dashboard
extends ReleaseExtension
implements CiWithInternalMetadata,
TenantAwareCi {
    public static final String GLOBAL_PARENT_ID = null;
    public static final String DASHBOARD_PREFIX = "summary";
    public static final String HOME_DASHBOARD_ID = "Applications/DashboardHome";
    private Map<String, InternalMetadata> $metadata = new LinkedHashMap<String, InternalMetadata>();
    @Property(description="Symbolic name for the dashboard. Max length of 255 characters.", required=false, defaultValue="Dashboard")
    private String title;
    @Property(description="Description for the dashboard.", required=false, size=Property.Size.MEDIUM)
    private String description;
    @Property(required=false, isTransient=true, description="Parent that the dashboard belongs to")
    private String parentId;
    @Property(required=false, description="The owner of this dashboard. This user has implicit read and edit permission on the dashboard")
    private String owner;
    @Property(asContainment=true, description="Tiles in this dashboard", required=false)
    private List<Tile> tiles = new ArrayList<Tile>();
    @Property(required=false, isTransient=true, description="List of roles or teams with view permission on this dashboard")
    private List<String> roleViewers = new ArrayList<String>();
    @Property(required=false, isTransient=true, description="List of roles or teams with edit permission on this dashboard")
    private List<String> roleEditors = new ArrayList<String>();
    @Property(required=false, description="Set number of rows the dashboard can contain")
    private Integer rows = 20;
    @Property(required=false, description="Number of columns the dashboard can contain")
    private Integer columns = 3;
    @Property(required=false, hidden=true, defaultValue="folder,global", description="Determines on which levels the dashboard template can be used.")
    private List<String> supportedScopes = new ArrayList<String>(Arrays.asList(TileScope.FOLDER.getValue(), TileScope.GLOBAL.getValue()));
    @Property(required=false, hidden=true, description="URI of the HTML file to render the configuration mode of this dashboard")
    private String configurationUri;
    @Property(required=false, hidden=true, description="Custom classpath location of the dashboard configuration Jython script")
    private String scriptLocation;
    @Property(required=false, hidden=true, description="Custom classpath location of the dashboard template JSON file")
    private String templateLocation;
    @Property(required=false, description="Auto refresh dashboard", defaultValue="false")
    private boolean autoRefresh;
    @Property(required=false, description="Dashboard auto-refresh interval in seconds", defaultValue="900")
    private Integer autoRefreshInterval = 900;
    @Property(required=false, description="The maximum number of tiles that the dashboard can show", defaultValue="99")
    private Integer maxTiles = 99;
    @Property(required=false, description="Tenant attached to this dashboard", category="internal", hidden=true)
    private String tenantId;

    public void setId(String id) {
        this.id = id;
        if (id != null && !this.id.equals(id)) {
            this.tiles.forEach(tile -> tile.setId(id + "/" + Ids.getName((String)tile.getId())));
        }
    }

    public boolean isSupportedOn(TileScope scope) {
        return this.supportedScopes.contains(scope.getValue());
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Tile getTile(String tileId) {
        return this.tiles.stream().filter(tile -> tileId.equals(tile.getId())).findFirst().orElseThrow(() -> new LogFriendlyNotFoundException("Tile [%s] not found", new Object[]{tileId}));
    }

    public boolean hasConfigurationScript() {
        return StringUtils.hasText((String)this.scriptLocation);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<Tile> getTiles() {
        return this.tiles;
    }

    public void setTiles(List<Tile> tiles) {
        if (tiles != null) {
            Checks.checkArgument((tiles.size() <= this.maxTiles ? 1 : 0) != 0, (String)String.format("The maximum number of tiles allowed for this dashboard is %s", this.maxTiles), (Object[])new Object[0]);
        }
        this.tiles = tiles;
    }

    public List<String> getRoleViewers() {
        return this.roleViewers;
    }

    public void setRoleViewers(List<String> roleViewers) {
        this.roleViewers = roleViewers;
    }

    public List<String> getRoleEditors() {
        return this.roleEditors;
    }

    public void setRoleEditors(List<String> roleEditors) {
        this.roleEditors = roleEditors;
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        super.accept(visitor);
        this.tiles.forEach(tile -> tile.accept(visitor));
    }

    @Override
    public Map<String, InternalMetadata> get$metadata() {
        return this.$metadata;
    }

    public boolean isReleaseDashboard() {
        return this.getId() != null && Ids.isReleaseId((String)Ids.getParentId((String)this.getId()));
    }

    public boolean isFolderDashboard() {
        return this.getParentId() != null && Ids.isFolderId((String)this.getParentId());
    }

    public boolean isGlobalDashboard() {
        return this.getParentId() == null && !this.isHomeDashboard();
    }

    public boolean isHomeDashboard() {
        return this.getId() != null && this.getId().equals(HOME_DASHBOARD_ID);
    }

    public Integer getRows() {
        return this.rows;
    }

    public Integer getColumns() {
        return this.columns;
    }

    public void setColumns(Integer columns) {
        this.columns = columns;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public String getTemplateLocation() {
        return this.templateLocation;
    }

    public void setTemplateLocation(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    public boolean getAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public Integer getAutoRefreshInterval() {
        return this.autoRefreshInterval;
    }

    public void setAutoRefreshInterval(Integer autoRefreshInterval) {
        this.autoRefreshInterval = autoRefreshInterval;
    }

    public Integer getMaxTiles() {
        return this.maxTiles;
    }

    public void setMaxTiles(Integer maxTiles) {
        this.maxTiles = maxTiles;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}

