/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.extension.quartz;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.extension.quartz.QuartzCalendars$;
import org.apache.pekko.extension.quartz.QuartzCronSchedule;
import org.apache.pekko.extension.quartz.QuartzSchedule;
import org.apache.pekko.extension.quartz.QuartzSchedulerExtension$;
import org.apache.pekko.extension.quartz.QuartzSchedules$;
import org.apache.pekko.extension.quartz.SimpleActorMessageJob;
import org.apache.pekko.extension.quartz.package$;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\rMq!B#G\u0011\u0003\tf!B*G\u0011\u0003!\u0006B\u00026\u0002\t\u0003\u0011I\u0010C\u0004\u0003|\u0006!\tE!@\t\u000f\r\u0005\u0011\u0001\"\u0011\u0004\u0004!91QB\u0001\u0005B\r=a\u0001B*G\u0001\tD\u0001B\u001a\u0004\u0003\u0002\u0003\u0006Ia\u001a\u0005\u0006U\u001a!\ta\u001b\u0005\b[\u001a\u0011\r\u0011\"\u0003o\u0011\u0019)h\u0001)A\u0005_\")aO\u0002C\u0001o\"9\u0011q\u0001\u0004\u0005\u0012\u0005%\u0001\"CA\u000f\r\t\u0007I\u0011AA\u0010\u0011!\t9C\u0002Q\u0001\n\u0005\u0005\u0002\"CA\u0015\r\t\u0007I\u0011AA\u0010\u0011!\tYC\u0002Q\u0001\n\u0005\u0005\u0002\"CA\u0017\r\t\u0007I\u0011AA\u0018\u0011!\t9D\u0002Q\u0001\n\u0005E\u0002\"CA\u001d\r\t\u0007I\u0011AA\u001e\u0011!\tiE\u0002Q\u0001\n\u0005u\u0002\"CA(\r\t\u0007I\u0011AA)\u0011!\tIG\u0002Q\u0001\n\u0005M\u0003\"CA6\r\t\u0007I\u0011AA7\u0011!\tYH\u0002Q\u0001\n\u0005=\u0004bBA?\r\u0011\u0005\u0011q\u0010\u0005\b\u0003\u000f3A\u0011AA\u0018\u0011\u001d\tII\u0002C\u0001\u0003\u0017Cq!!$\u0007\t\u0003\ty\u0003C\u0004\u0002\u0010\u001a!\t!!%\t\u000f\u0005\rf\u0001\"\u0001\u0002\u0000!9\u0011Q\u0015\u0004\u0005\u0002\u0005\u001d\u0006\"CAW\rE\u0005I\u0011AAX\u0011\u001d\t)M\u0002C\u0001\u0003\u000fDq!a3\u0007\t\u0003\ti\rC\u0004\u0002R\u001a!\t!a \t\u000f\u0005Mg\u0001\"\u0001\u0002V\"9\u0011\u0011\u001c\u0004\u0005\u0002\u0005m\u0007\"CA\u0000\rE\u0005I\u0011\u0001B\u0001\u0011%\u0011)ABI\u0001\n\u0003\u0011\t\u0001C\u0005\u0003\b\u0019\t\n\u0011\"\u0001\u0003\n!9!Q\u0002\u0004\u0005\u0002\t=\u0001\"\u0003B\u0010\rE\u0005I\u0011\u0001B\u0001\u0011%\u0011\tCBI\u0001\n\u0003\u0011\t\u0001C\u0005\u0003$\u0019\t\n\u0011\"\u0001\u0003\n!9!Q\u0005\u0004\u0005\u0002\t\u001d\u0002b\u0002B\u0016\r\u0011\u0005\u0011q\u0010\u0005\b\u0005[1A\u0011\u0001B\u0018\u0011\u001d\u0011\u0019D\u0002C\u0001\u0005kA\u0011B!\u0011\u0007#\u0003%\tA!\u0001\t\u0013\t\rc!%A\u0005\u0002\t\u0005\u0001\"\u0003B#\rE\u0005I\u0011\u0001B\u0005\u0011\u001d\u00119E\u0002C\u0001\u0005\u0013B\u0011B!\u0017\u0007#\u0003%\tA!\u0001\t\u0013\tmc!%A\u0005\u0002\t\u0005\u0001\"\u0003B/\rE\u0005I\u0011\u0001B\u0005\u0011!\u0011yF\u0002C\u0001\r\n\u0005\u0004b\u0002B3\r\u0011\u0005!q\r\u0005\b\u0005K2A\u0011\u0001B8\u0011\u001d\u0011)G\u0002C\u0001\u0005{BqA!\u001a\u0007\t\u0003\u0011Y\tC\u0004\u0003f\u0019!\tAa&\t\u000f\t\u0015d\u0001\"\u0001\u0003\"\"A!1\u0016\u0004\u0005\u0002\u0019\u0013i\u000b\u0003\u0005\u00038\u001a!\tA\u0012B]\u0011\u001d\u00119M\u0002C\t\u0003\u007fB!B!3\u0007\u0011\u000b\u0007I\u0011\u0003Bf\u0011)\u0011IN\u0002EC\u0002\u0013E!1\u001c\u0005\u000b\u0005S4\u0001R1A\u0005\u0012\t-\u0018\u0001G)vCJ$(pU2iK\u0012,H.\u001a:FqR,gn]5p]*\u0011q\tS\u0001\u0007cV\f'\u000f\u001e>\u000b\u0005%S\u0015!C3yi\u0016t7/[8o\u0015\tYE*A\u0003qK.\\wN\u0003\u0002N\u001d\u00061\u0011\r]1dQ\u0016T\u0011aT\u0001\u0004_J<7\u0001\u0001\t\u0003%\u0006i\u0011A\u0012\u0002\u0019#V\f'\u000f\u001e>TG\",G-\u001e7fe\u0016CH/\u001a8tS>t7#B\u0001V7\nM\bC\u0001,Z\u001b\u00059&\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;&AB!osJ+g\rE\u0002]?\u0006l\u0011!\u0018\u0006\u0003=*\u000bQ!Y2u_JL!\u0001Y/\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003%\u001a\u00192AB+d!\taF-\u0003\u0002f;\nIQ\t\u001f;f]NLwN\\\u0001\u0007gf\u001cH/Z7\u0011\u0005qC\u0017BA5^\u0005-\t5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\t\tG\u000eC\u0003g\u0011\u0001\u0007q-A\u0002m_\u001e,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003e*\u000bQ!\u001a<f]RL!\u0001^9\u0003\u001d1{wmZ5oO\u0006#\u0017\r\u001d;fe\u0006!An\\4!\u00035\u00198\r[3ek2,'OT1nKV\t\u0001\u0010E\u0002z\u0003\u0003q!A\u001f@\u0011\u0005m<V\"\u0001?\u000b\u0005u\u0004\u0016A\u0002\u001fs_>$h(\u0003\u0002\u0000/\u00061\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t11\u000b\u001e:j]\u001eT!a`,\u0002\r\r|gNZ5h+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005eQBAA\b\u0015\u0011\t9!!\u0005\u000b\t\u0005M\u0011QC\u0001\tif\u0004Xm]1gK*\u0011\u0011qC\u0001\u0004G>l\u0017\u0002BA\u000e\u0003\u001f\u0011aaQ8oM&<\u0017a\u0003;ie\u0016\fGmQ8v]R,\"!!\t\u0011\u0007Y\u000b\u0019#C\u0002\u0002&]\u00131!\u00138u\u00031!\bN]3bI\u000e{WO\u001c;!\u00039!\bN]3bIB\u0013\u0018n\u001c:jif\fq\u0002\u001e5sK\u0006$\u0007K]5pe&$\u0018\u0010I\u0001\u0015I\u0006,Wn\u001c8UQJ,\u0017\rZ:`IEl\u0017M]6\u0016\u0005\u0005E\u0002c\u0001,\u00024%\u0019\u0011QG,\u0003\u000f\t{w\u000e\\3b]\u0006)B-Y3n_:$\u0006N]3bIN|F%]7be.\u0004\u0013a\u00043fM\u0006,H\u000e\u001e+j[\u0016TxN\\3\u0016\u0005\u0005u\u0002\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0005kRLGN\u0003\u0002\u0002H\u0005!!.\u0019<b\u0013\u0011\tY%!\u0011\u0003\u0011QKW.\u001a.p]\u0016\f\u0001\u0003Z3gCVdG\u000fV5nKj|g.\u001a\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u001cXCAA*!\u001d\t)&a\u0018y\u0003Gj!!a\u0016\u000b\t\u0005e\u00131L\u0001\u000bG>t7-\u001e:sK:$(bAA//\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u0014q\u000b\u0002\b)JLW-T1q!\r\u0011\u0016QM\u0005\u0004\u0003O2%AD)vCJ$(pU2iK\u0012,H.Z\u0001\u000bg\u000eDW\rZ;mKN\u0004\u0013a\u0003:v]:Lgn\u001a&pEN,\"!a\u001c\u0011\u000f\u0005U\u0013q\f=\u0002rA!\u00111OA<\u001b\t\t)H\u0003\u0002H\u001d&!\u0011\u0011PA;\u0005\u0019QuNY&fs\u0006a!/\u001e8oS:<'j\u001c2tA\u000591\u000f^1oI\nLHCAAA!\r1\u00161Q\u0005\u0004\u0003\u000b;&\u0001B+oSR\fq\"[:J]N#\u0018M\u001c3cs6{G-Z\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003c\t\u0011\"[:Ti\u0006\u0014H/\u001a3\u0002\u00179,\u0007\u0010\u001e+sS\u001e<WM\u001d\u000b\u0005\u0003'\u000by\nE\u0003W\u0003+\u000bI*C\u0002\u0002\u0018^\u0013aa\u00149uS>t\u0007\u0003BA \u00037KA!!(\u0002B\t!A)\u0019;f\u0011\u0019\t\t+\ba\u0001q\u0006!a.Y7f\u0003)\u0019Xo\u001d9f]\u0012\fE\u000e\\\u0001\tg\",H\u000fZ8x]R!\u0011\u0011QAU\u0011%\tYk\bI\u0001\u0002\u0004\t\t$A\u000bxC&$hi\u001c:K_\n\u001cHk\\\"p[BdW\r^3\u0002%MDW\u000f\u001e3po:$C-\u001a4bk2$H%M\u000b\u0003\u0003cSC!!\r\u00024.\u0012\u0011Q\u0017\t\u0005\u0003o\u000b\t-\u0004\u0002\u0002:*!\u00111XA_\u0003%)hn\u00195fG.,GMC\u0002\u0002@^\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019-!/\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006tkN\u0004XM\u001c3K_\n$B!!\r\u0002J\"1\u0011\u0011U\u0011A\u0002a\f\u0011B]3tk6,'j\u001c2\u0015\t\u0005E\u0012q\u001a\u0005\u0007\u0003C\u0013\u0003\u0019\u0001=\u0002\u0013I,7/^7f\u00032d\u0017!C2b]\u000e,GNS8c)\u0011\t\t$a6\t\r\u0005\u0005F\u00051\u0001y\u0003E\u0019'/Z1uK*{'mU2iK\u0012,H.\u001a\u000b\u0011\u00033\u000bi.a8\u0002j\u00065\u00181_A|\u0003wDa!!)&\u0001\u0004A\bbBAqK\u0001\u0007\u00111]\u0001\te\u0016\u001cW-\u001b<feB\u0019A,!:\n\u0007\u0005\u001dXL\u0001\u0005BGR|'OU3g\u0011\u0019\tY/\na\u0001+\u0006\u0019Qn]4\t\u0013\u0005=X\u0005%AA\u0002\u0005E\u0018a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004BAVAKq\"1\u0011Q_\u0013A\u0002a\fab\u0019:p]\u0016C\bO]3tg&|g\u000eC\u0005\u0002z\u0016\u0002\n\u00111\u0001\u0002r\u0006A1-\u00197f]\u0012\f'\u000fC\u0005\u0002~\u0016\u0002\n\u00111\u0001\u0002>\u0005AA/[7fu>tW-A\u000ede\u0016\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u0007QC!!=\u00024\u0006Y2M]3bi\u0016TuNY*dQ\u0016$W\u000f\\3%I\u00164\u0017-\u001e7uIY\n1d\u0019:fCR,'j\u001c2TG\",G-\u001e7fI\u0011,g-Y;mi\u0012:TC\u0001B\u0006U\u0011\ti$a-\u0002#U\u0004H-\u0019;f\u0015>\u00147k\u00195fIVdW\r\u0006\t\u0002\u001a\nE!1\u0003B\u000b\u0005/\u0011IBa\u0007\u0003\u001e!1\u0011\u0011U\u0015A\u0002aDq!!9*\u0001\u0004\t\u0019\u000f\u0003\u0004\u0002l&\u0002\r!\u0016\u0005\n\u0003_L\u0003\u0013!a\u0001\u0003cDa!!>*\u0001\u0004A\b\"CA}SA\u0005\t\u0019AAy\u0011%\ti0\u000bI\u0001\u0002\u0004\ti$A\u000eva\u0012\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$C-\u001a4bk2$H\u0005N\u0001\u001ckB$\u0017\r^3K_\n\u001c6\r[3ek2,G\u0005Z3gCVdG\u000f\n\u001c\u00027U\u0004H-\u0019;f\u0015>\u00147k\u00195fIVdW\r\n3fM\u0006,H\u000e\u001e\u00138\u0003E!W\r\\3uK*{'mU2iK\u0012,H.\u001a\u000b\u0005\u0003c\u0011I\u0003\u0003\u0004\u0002\"6\u0002\r\u0001_\u0001\nI\u0016dW\r^3BY2\fQ\"\u001e8tG\",G-\u001e7f\u0015>\u0014G\u0003BA\u0019\u0005cAa!!)0\u0001\u0004A\u0018AD2sK\u0006$XmU2iK\u0012,H.\u001a\u000b\r\u0003\u0003\u00139D!\u000f\u0003<\tu\"q\b\u0005\u0007\u0003C\u0003\u0004\u0019\u0001=\t\u0013\u0005=\b\u0007%AA\u0002\u0005E\bBBA{a\u0001\u0007\u0001\u0010C\u0005\u0002zB\u0002\n\u00111\u0001\u0002r\"I\u0011Q \u0019\u0011\u0002\u0003\u0007\u0011QH\u0001\u0019GJ,\u0017\r^3TG\",G-\u001e7fI\u0011,g-Y;mi\u0012\u0012\u0014\u0001G2sK\u0006$XmU2iK\u0012,H.\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005A2M]3bi\u0016\u001c6\r[3ek2,G\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bI,7o\u00195fIVdWMS8c)A\tIJa\u0013\u0003N\t=#\u0011\u000bB*\u0005+\u00129\u0006\u0003\u0004\u0002\"R\u0002\r\u0001\u001f\u0005\b\u0003C$\u0004\u0019AAr\u0011\u0019\tY\u000f\u000ea\u0001+\"I\u0011q\u001e\u001b\u0011\u0002\u0003\u0007\u0011\u0011\u001f\u0005\u0007\u0003k$\u0004\u0019\u0001=\t\u0013\u0005eH\u0007%AA\u0002\u0005E\b\"CA\u007fiA\u0005\t\u0019AA\u001f\u0003]\u0011Xm]2iK\u0012,H.\u001a&pE\u0012\"WMZ1vYR$C'A\fsKN\u001c\u0007.\u001a3vY\u0016TuN\u0019\u0013eK\u001a\fW\u000f\u001c;%m\u00059\"/Z:dQ\u0016$W\u000f\\3K_\n$C-\u001a4bk2$HeN\u0001\u000fe\u0016lwN^3TG\",G-\u001e7f)\u0011\t\u0019Fa\u0019\t\r\u0005\u0005\u0006\b1\u0001y\u0003!\u00198\r[3ek2,G\u0003CAM\u0005S\u0012YG!\u001c\t\r\u0005\u0005\u0016\b1\u0001y\u0011\u001d\t\t/\u000fa\u0001\u0003GDa!a;:\u0001\u0004)F\u0003CAM\u0005c\u0012\u0019Ha\u001f\t\r\u0005\u0005&\b1\u0001y\u0011\u001d\t\tO\u000fa\u0001\u0005k\u00022\u0001\u0018B<\u0013\r\u0011I(\u0018\u0002\u000f\u0003\u000e$xN]*fY\u0016\u001cG/[8o\u0011\u0019\tYO\u000fa\u0001+RA\u0011\u0011\u0014B@\u0005\u0003\u0013I\t\u0003\u0004\u0002\"n\u0002\r\u0001\u001f\u0005\b\u0003C\\\u0004\u0019\u0001BB!\r\u0001(QQ\u0005\u0004\u0005\u000f\u000b(aC#wK:$8\u000b\u001e:fC6Da!a;<\u0001\u0004)FCCAM\u0005\u001b\u0013yI!%\u0003\u0014\"1\u0011\u0011\u0015\u001fA\u0002aDq!!9=\u0001\u0004\t\u0019\u000f\u0003\u0004\u0002lr\u0002\r!\u0016\u0005\b\u0005+c\u0004\u0019AAJ\u0003%\u0019H/\u0019:u\t\u0006$X\r\u0006\u0006\u0002\u001a\ne%1\u0014BO\u0005?Ca!!)>\u0001\u0004A\bbBAq{\u0001\u0007!Q\u000f\u0005\u0007\u0003Wl\u0004\u0019A+\t\u000f\tUU\b1\u0001\u0002\u0014RQ\u0011\u0011\u0014BR\u0005K\u00139K!+\t\r\u0005\u0005f\b1\u0001y\u0011\u001d\t\tO\u0010a\u0001\u0005\u0007Ca!a;?\u0001\u0004)\u0006b\u0002BK}\u0001\u0007\u00111S\u0001\u0011g\u000eDW\rZ;mK&sG/\u001a:oC2$\"\"!'\u00030\nE&1\u0017B[\u0011\u0019\t\tk\u0010a\u0001q\"1\u0011\u0011] A\u0002UCa!a;@\u0001\u0004)\u0006b\u0002BK\u007f\u0001\u0007\u00111S\u0001\fg\u000eDW\rZ;mK*{'\r\u0006\u0006\u0003<\n}&\u0011\u0019Bb\u0005\u000b$B!!'\u0003>\"9!Q\r!A\u0002\u0005\r\u0004BBAQ\u0001\u0002\u0007\u0001\u0010\u0003\u0004\u0002b\u0002\u0003\r!\u0016\u0005\u0007\u0003W\u0004\u0005\u0019A+\t\u000f\tU\u0005\t1\u0001\u0002\u0014\u0006\u0019\u0012N\\5uS\u0006d\u0017n]3DC2,g\u000eZ1sg\u0006QA\u000f\u001b:fC\u0012\u0004vn\u001c7\u0016\u0005\t5\u0007\u0003\u0002Bh\u0005+l!A!5\u000b\t\tM\u0017QO\u0001\u0006g&l\u0007\u000f\\\u0005\u0005\u0005/\u0014\tN\u0001\tTS6\u0004H.\u001a+ie\u0016\fG\rU8pY\u0006A!n\u001c2Ti>\u0014X-\u0006\u0002\u0003^B!!q\u001cBs\u001b\t\u0011\tO\u0003\u0003\u0003d\u0006U\u0014aA:qS&!!q\u001dBq\u0005!QuNY*u_J,\u0017!C:dQ\u0016$W\u000f\\3s+\t\u0011i\u000f\u0005\u0003\u0002t\t=\u0018\u0002\u0002By\u0003k\u0012\u0011bU2iK\u0012,H.\u001a:\u0011\u0007q\u0013)0C\u0002\u0003xv\u00131#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\u0012!U\u0001\u0007Y>|7.\u001e9\u0016\u0005\t}hB\u0001*\u0001\u0003=\u0019'/Z1uK\u0016CH/\u001a8tS>tGcA1\u0004\u0006!1a\r\u0002a\u0001\u0007\u000f\u00012\u0001XB\u0005\u0013\r\u0019Y!\u0018\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\u0004O\u0016$HcA1\u0004\u0012!)a-\u0002a\u0001O\u0002")
public class QuartzSchedulerExtension
implements Extension {
    private SimpleThreadPool threadPool;
    private JobStore jobStore;
    private Scheduler scheduler;
    private final ActorSystem system;
    private final LoggingAdapter log;
    private final int threadCount;
    private final int threadPriority;
    private final boolean daemonThreads_$qmark;
    private final TimeZone defaultTimezone;
    private final TrieMap<String, QuartzSchedule> schedules;
    private final TrieMap<String, JobKey> runningJobs;
    private volatile byte bitmap$0;

    public static QuartzSchedulerExtension get(ActorSystem system) {
        return QuartzSchedulerExtension$.MODULE$.get(system);
    }

    public static QuartzSchedulerExtension createExtension(ExtendedActorSystem system) {
        return QuartzSchedulerExtension$.MODULE$.createExtension(system);
    }

    public static QuartzSchedulerExtension$ lookup() {
        return QuartzSchedulerExtension$.MODULE$.lookup();
    }

    public static Extension get(ClassicActorSystemProvider system) {
        return QuartzSchedulerExtension$.MODULE$.get(system);
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return QuartzSchedulerExtension$.MODULE$.apply(system);
    }

    public static Extension apply(ActorSystem system) {
        return QuartzSchedulerExtension$.MODULE$.apply(system);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    public String schedulerName() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("QuartzScheduler~%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.system.name()}));
    }

    public Config config() {
        return this.system.settings().config().getConfig("pekko.quartz").root().toConfig();
    }

    public int threadCount() {
        return this.threadCount;
    }

    public int threadPriority() {
        return this.threadPriority;
    }

    public boolean daemonThreads_$qmark() {
        return this.daemonThreads_$qmark;
    }

    public TimeZone defaultTimezone() {
        return this.defaultTimezone;
    }

    public TrieMap<String, QuartzSchedule> schedules() {
        return this.schedules;
    }

    public TrieMap<String, JobKey> runningJobs() {
        return this.runningJobs;
    }

    public void standby() {
        this.scheduler().standby();
    }

    public boolean isInStandbyMode() {
        return this.scheduler().isInStandbyMode();
    }

    public boolean start() {
        if (this.isStarted()) {
            this.log().warning("Cannot start scheduler, already started.");
            return false;
        }
        this.scheduler().start();
        return true;
    }

    public boolean isStarted() {
        return this.scheduler().isStarted();
    }

    public Option<Date> nextTrigger(String name) {
        return this.runningJobs().get((Object)name).flatMap((Function1 & Serializable)jobKey -> ((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getTriggersOfJob(jobKey)).asScala()).headOption().map((Function1 & Serializable)trigger -> trigger.getNextFireTime()));
    }

    public void suspendAll() {
        this.log().info("Suspending all Quartz jobs.");
        this.scheduler().pauseAll();
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.scheduler().shutdown(waitForJobsToComplete);
    }

    public boolean shutdown$default$1() {
        return false;
    }

    public boolean suspendJob(String name) {
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Suspending Quartz Job '{}'", (Object)name);
            this.scheduler().pauseJob(job);
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot suspend", (Object)name);
            return false;
        }
        throw new MatchError((Object)option);
    }

    public boolean resumeJob(String name) {
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Resuming Quartz Job '{}'", (Object)name);
            this.scheduler().resumeJob(job);
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot unpause", (Object)name);
            return false;
        }
        throw new MatchError((Object)option);
    }

    public void resumeAll() {
        this.log().info("Resuming all Quartz jobs.");
        this.scheduler().resumeAll();
    }

    public boolean cancelJob(String name) {
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Cancelling Quartz Job '{}'", (Object)name);
            boolean result = this.scheduler().deleteJob(job);
            this.runningJobs().$minus$eq((Object)name);
            return result;
        }
        if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot cancel", (Object)name);
            return false;
        }
        throw new MatchError((Object)option);
    }

    public Date createJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.schedule(name, receiver, msg);
    }

    public Option<String> createJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> createJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone createJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public Date updateJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        return this.rescheduleJob(name, receiver, msg, description, cronExpression, calendar, timezone);
    }

    public Option<String> updateJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> updateJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone updateJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public boolean deleteJobSchedule(String name) {
        return this.unscheduleJob(name);
    }

    public void deleteAll() {
        this.log().info("Deleting all Quartz jobs.");
        this.runningJobs().clear();
        this.schedules().clear();
        this.scheduler().clear();
    }

    public boolean unscheduleJob(String name) {
        boolean isJobCancelled = this.cancelJob(name);
        TrieMap<String, QuartzSchedule> trieMap = isJobCancelled ? this.removeSchedule(name) : BoxedUnit.UNIT;
        return isJobCancelled;
    }

    public void createSchedule(String name, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        Either either = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class})).either((Function0 & Serializable)() -> new CronExpression(cronExpression));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(new StringBuilder(77).append("Invalid 'expression' for Cron Schedule '").append(name).append("'. Failed to validate CronExpression.").toString(), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        CronExpression expr = (CronExpression)right.value();
        CronExpression expression = expr;
        QuartzCronSchedule schedule = new QuartzCronSchedule(name, description, expression, timezone, calendar);
        Option option = this.schedules().putIfAbsent((Object)name, (Object)schedule);
        if (option instanceof Some) {
            throw new IllegalArgumentException(new StringBuilder(44).append("A schedule with this name already exists: [").append(name).append("]").toString());
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    public Option<String> createSchedule$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createSchedule$default$4() {
        return None$.MODULE$;
    }

    public TimeZone createSchedule$default$5() {
        return this.defaultTimezone();
    }

    public Date rescheduleJob(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.cancelJob(name);
        this.removeSchedule(name);
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Option<String> rescheduleJob$default$4() {
        return None$.MODULE$;
    }

    public Option<String> rescheduleJob$default$6() {
        return None$.MODULE$;
    }

    public TimeZone rescheduleJob$default$7() {
        return this.defaultTimezone();
    }

    public TrieMap<String, QuartzSchedule> removeSchedule(String name) {
        return (TrieMap)this.schedules().$minus$eq((Object)name);
    }

    public Date schedule(String name, ActorRef receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, EventStream receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorRef receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, EventStream receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date scheduleInternal(String name, Object receiver, Object msg, Option<Date> startDate) {
        Option option = this.schedules().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            QuartzSchedule schedule = (QuartzSchedule)some.value();
            return this.scheduleJob(name, receiver, msg, startDate, schedule);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("No matching quartz configuration found for schedule '%s'"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        throw new MatchError((Object)option);
    }

    public Date scheduleJob(String name, Object receiver, Object msg, Option<Date> startDate, QuartzSchedule schedule) {
        this.log().info("Setting up scheduled job '{}', with '{}'", (Object)name, (Object)schedule);
        scala.collection.immutable.Map jobDataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logBus"), (Object)this.system.eventStream()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"receiver"), receiver), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), msg)}));
        JobDataMap jobData = JobDataMapSupport.newJobDataMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)jobDataMap).asJava()));
        JobDetail job = JobBuilder.newJob(SimpleActorMessageJob.class).withIdentity(new StringBuilder(4).append(name).append("_Job").toString()).usingJobData(jobData).withDescription((String)schedule.description().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).build();
        this.log().debug("Adding jobKey {} to runningJobs map.", (Object)job.getKey());
        this.runningJobs().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)job.getKey()));
        this.log().debug("Building Trigger with startDate '{}", startDate.getOrElse((Function0 & Serializable)() -> new Date()));
        Trigger trigger = schedule.buildTrigger(name, startDate);
        this.log().debug("Scheduling Job '{}' and Trigger '{}'. Is Scheduler Running? {}", (Object)job, (Object)trigger, (Object)BoxesRunTime.boxToBoolean((boolean)this.scheduler().isStarted()));
        return this.scheduler().scheduleJob(job, trigger);
    }

    public void initialiseCalendars() {
        QuartzCalendars$.MODULE$.apply(this.config(), this.defaultTimezone()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)QuartzSchedulerExtension.$anonfun$initialiseCalendars$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            QuartzSchedulerExtension.$anonfun$initialiseCalendars$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.log().info(new StringBuilder(23).append("Initialized calendars: ").append(((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getCalendarNames()).asScala()).mkString(",")).toString());
    }

    /*
     * WARNING - void declaration
     */
    private SimpleThreadPool threadPool$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                SimpleThreadPool _tp = new SimpleThreadPool(this.threadCount(), this.threadPriority());
                _tp.setThreadNamePrefix("PEKKO_QRTZ_");
                _tp.setMakeThreadsDaemons(this.daemonThreads_$qmark());
                this.threadPool = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.threadPool;
    }

    public SimpleThreadPool threadPool() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.threadPool$lzycompute();
        }
        return this.threadPool;
    }

    private JobStore jobStore$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.jobStore = new RAMJobStore();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.jobStore;
    }

    public JobStore jobStore() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.jobStore$lzycompute();
        }
        return this.jobStore;
    }

    /*
     * WARNING - void declaration
     */
    private Scheduler scheduler$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var2_2;
                DirectSchedulerFactory.getInstance().createScheduler(this.schedulerName(), this.system.name(), (ThreadPool)this.threadPool(), this.jobStore());
                Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(this.schedulerName());
                this.log().debug("Initialized a Quartz Scheduler '{}'", (Object)scheduler);
                this.system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    this.log().info("Shutting down Quartz Scheduler with ActorSystem Termination (Any jobs awaiting completion will end as well, as actors are ending)...");
                    scheduler.shutdown(false);
                });
                this.scheduler = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.scheduler;
    }

    public Scheduler scheduler() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.scheduler$lzycompute();
        }
        return this.scheduler;
    }

    public static final /* synthetic */ boolean $anonfun$initialiseCalendars$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$initialiseCalendars$2(QuartzSchedulerExtension $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Calendar calendar = (Calendar)tuple2._2();
            $this.log().info("Configuring Calendar '{}'", (Object)name);
            $this.scheduler().addCalendar(name, calendar, true, true);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public QuartzSchedulerExtension(ActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply(system, (Object)this, package$.MODULE$.quartzExtensionLoggerType());
        this.threadCount = this.config().getInt("threadPool.threadCount");
        Predef$.MODULE$.require(this.threadCount() >= 1, (Function0 & Serializable)() -> "Quartz Thread Count (pekko.quartz.threadPool.threadCount) must be a positive integer.");
        this.threadPriority = this.config().getInt("threadPool.threadPriority");
        Predef$.MODULE$.require(this.threadPriority() >= 1 && this.threadPriority() <= 10, (Function0 & Serializable)() -> "Quartz Thread Priority (pekko.quartz.threadPool.threadPriority) must be a positive integer between 1 (lowest) and 10 (highest).");
        this.daemonThreads_$qmark = this.config().getBoolean("threadPool.daemonThreads");
        this.defaultTimezone = TimeZone.getTimeZone(this.config().getString("defaultTimezone"));
        this.schedules = new TrieMap();
        this.schedules().$plus$plus$eq(QuartzSchedules$.MODULE$.apply(this.config(), this.defaultTimezone()));
        this.runningJobs = new TrieMap();
        this.log().debug("Configured Schedules: {}", this.schedules());
        this.scheduler().start();
        this.initialiseCalendars();
    }
}

