/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JwtAuthenticationOptions {
    public static final String DEFAULT_JWT_AUTHENTICATION_PATH = "jwt";
    private final String path;
    @Nullable
    private final String role;
    private final Supplier<String> jwtSupplier;

    private JwtAuthenticationOptions(@Nullable String role, Supplier<String> jwtSupplier, String path) {
        this.role = role;
        this.jwtSupplier = jwtSupplier;
        this.path = path;
    }

    public static JwtAuthenticationOptionsBuilder builder() {
        return new JwtAuthenticationOptionsBuilder();
    }

    @Nullable
    public String getRole() {
        return this.role;
    }

    public Supplier<String> getJwtSupplier() {
        return this.jwtSupplier;
    }

    public String getPath() {
        return this.path;
    }

    public static class JwtAuthenticationOptionsBuilder {
        private String path = "jwt";
        @Nullable
        private String role;
        @Nullable
        private Supplier<String> jwtSupplier;

        public JwtAuthenticationOptionsBuilder path(String path) {
            Assert.hasText((String)path, (String)"Path must not be empty");
            this.path = path;
            return this;
        }

        public JwtAuthenticationOptionsBuilder role(String role) {
            Assert.hasText((String)role, (String)"Role must not be empty");
            this.role = role;
            return this;
        }

        public JwtAuthenticationOptionsBuilder jwt(String jwt) {
            Assert.hasText((String)jwt, (String)"JWT must not be empty");
            return this.jwtSupplier(() -> jwt);
        }

        public JwtAuthenticationOptionsBuilder jwtSupplier(Supplier<String> jwtSupplier) {
            Assert.notNull(jwtSupplier, (String)"JWT supplier must not be null");
            this.jwtSupplier = jwtSupplier;
            return this;
        }

        public JwtAuthenticationOptions build() {
            Assert.notNull(this.jwtSupplier, (String)"JWT must not be null");
            return new JwtAuthenticationOptions(this.role, this.jwtSupplier, this.path);
        }
    }
}

