/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import java.util.List;
import org.springframework.vault.support.Ciphertext;
import org.springframework.vault.support.Hmac;
import org.springframework.vault.support.Plaintext;
import org.springframework.vault.support.RawTransitKey;
import org.springframework.vault.support.Signature;
import org.springframework.vault.support.SignatureValidation;
import org.springframework.vault.support.TransitKeyType;
import org.springframework.vault.support.VaultDecryptionResult;
import org.springframework.vault.support.VaultEncryptionResult;
import org.springframework.vault.support.VaultHmacRequest;
import org.springframework.vault.support.VaultSignRequest;
import org.springframework.vault.support.VaultSignatureVerificationRequest;
import org.springframework.vault.support.VaultTransitContext;
import org.springframework.vault.support.VaultTransitKey;
import org.springframework.vault.support.VaultTransitKeyConfiguration;
import org.springframework.vault.support.VaultTransitKeyCreationRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveVaultTransitOperations {
    public Mono<Void> createKey(String var1);

    public Mono<Void> createKey(String var1, VaultTransitKeyCreationRequest var2);

    public Flux<String> getKeys();

    public Mono<Void> configureKey(String var1, VaultTransitKeyConfiguration var2);

    public Mono<RawTransitKey> exportKey(String var1, TransitKeyType var2);

    public Mono<VaultTransitKey> getKey(String var1);

    public Mono<Void> deleteKey(String var1);

    public Mono<Void> rotate(String var1);

    public Mono<String> encrypt(String var1, String var2);

    public Mono<Ciphertext> encrypt(String var1, Plaintext var2);

    public Mono<String> encrypt(String var1, byte[] var2, VaultTransitContext var3);

    public Flux<VaultEncryptionResult> encrypt(String var1, List<Plaintext> var2);

    public Mono<String> decrypt(String var1, String var2);

    public Mono<Plaintext> decrypt(String var1, Ciphertext var2);

    public Mono<byte[]> decrypt(String var1, String var2, VaultTransitContext var3);

    public Flux<VaultDecryptionResult> decrypt(String var1, List<Ciphertext> var2);

    public Mono<String> rewrap(String var1, String var2);

    public Mono<String> rewrap(String var1, String var2, VaultTransitContext var3);

    public Flux<VaultEncryptionResult> rewrap(String var1, List<Ciphertext> var2);

    public Mono<Hmac> getHmac(String var1, Plaintext var2);

    public Mono<Hmac> getHmac(String var1, VaultHmacRequest var2);

    public Mono<Signature> sign(String var1, Plaintext var2);

    public Mono<Signature> sign(String var1, VaultSignRequest var2);

    public Mono<Boolean> verify(String var1, Plaintext var2, Signature var3);

    public Mono<SignatureValidation> verify(String var1, VaultSignatureVerificationRequest var2);
}

