/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.vault.support.DurationParser;

public class VaultMetadataRequest {
    @JsonProperty(value="max_versions")
    private final int maxVersions;
    @JsonProperty(value="cas_required")
    private final boolean casRequired;
    @JsonProperty(value="delete_version_after")
    private final String deleteVersionAfter;
    @JsonProperty(value="custom_metadata")
    @Nullable
    private final Map<String, String> customMetadata;

    private VaultMetadataRequest(boolean casRequired, @Nullable Map<String, String> customMetadata, @Nullable Duration deleteVersionAfter, int maxVersions) {
        this.casRequired = casRequired;
        this.customMetadata = customMetadata;
        this.deleteVersionAfter = DurationParser.formatDuration(deleteVersionAfter != null ? deleteVersionAfter : Duration.ZERO);
        this.maxVersions = maxVersions;
    }

    public static VaultMetadataRequestBuilder builder() {
        return new VaultMetadataRequestBuilder();
    }

    public boolean isCasRequired() {
        return this.casRequired;
    }

    @Nullable
    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    public String getDeleteVersionAfter() {
        return this.deleteVersionAfter;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public static class VaultMetadataRequestBuilder {
        private boolean casRequired;
        @Nullable
        private Map<String, String> customMetadata;
        @Nullable
        private Duration deleteVersionAfter;
        private int maxVersions;

        public VaultMetadataRequestBuilder casRequired() {
            return this.casRequired(true);
        }

        public VaultMetadataRequestBuilder casRequired(boolean casRequired) {
            this.casRequired = casRequired;
            return this;
        }

        public VaultMetadataRequestBuilder customMetadata(Map<String, String> customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public VaultMetadataRequestBuilder deleteVersionAfter(Duration deleteVersionAfter) {
            this.deleteVersionAfter = deleteVersionAfter;
            return this;
        }

        public VaultMetadataRequestBuilder maxVersions(int maxVersions) {
            this.maxVersions = maxVersions;
            return this;
        }

        public VaultMetadataRequest build() {
            return new VaultMetadataRequest(this.casRequired, this.customMetadata, this.deleteVersionAfter, this.maxVersions);
        }
    }
}

