/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.dataservice;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.synopsys.integration.blackduck.api.generated.deprecated.view.PolicyStatusView;
import com.synopsys.integration.blackduck.api.generated.enumeration.ProjectVersionComponentPolicyStatusType;
import com.synopsys.integration.blackduck.api.generated.enumeration.ReportFormatType;
import com.synopsys.integration.blackduck.api.generated.enumeration.ReportType;
import com.synopsys.integration.blackduck.api.generated.view.CodeLocationView;
import com.synopsys.integration.blackduck.api.generated.view.ComponentPolicyRulesView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionComponentView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.api.generated.view.ReportView;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.blackduck.exception.RiskReportException;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.blackduck.service.dataservice.ProjectService;
import com.synopsys.integration.blackduck.service.model.BomComponent;
import com.synopsys.integration.blackduck.service.model.PolicyRule;
import com.synopsys.integration.blackduck.service.model.ReportData;
import com.synopsys.integration.blackduck.service.model.pdf.FontLoader;
import com.synopsys.integration.blackduck.service.model.pdf.RiskReportPdfWriter;
import com.synopsys.integration.blackduck.service.model.pdf.RiskReportWriter;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.response.Response;
import com.synopsys.integration.util.IntegrationEscapeUtil;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class ReportService
extends DataService {
    public static final long DEFAULT_TIMEOUT = 300000L;
    private final ProjectService projectDataService;
    private final IntegrationEscapeUtil escapeUtil;
    private final long timeoutInMilliseconds;
    private final HttpUrl blackDuckBaseUrl;
    private final Gson gson;

    public ReportService(Gson gson, HttpUrl blackDuckBaseUrl, BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, IntLogger logger, ProjectService projectDataService, IntegrationEscapeUtil escapeUtil) {
        this(gson, blackDuckBaseUrl, blackDuckApiClient, blackDuckRequestFactory, logger, projectDataService, escapeUtil, 300000L);
    }

    public ReportService(Gson gson, HttpUrl blackDuckBaseUrl, BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, IntLogger logger, ProjectService projectDataService, IntegrationEscapeUtil escapeUtil, long timeoutInMilliseconds) {
        super(blackDuckApiClient, blackDuckRequestFactory, logger);
        this.projectDataService = projectDataService;
        this.escapeUtil = escapeUtil;
        long timeout = timeoutInMilliseconds;
        if (timeoutInMilliseconds <= 0L) {
            timeout = 300000L;
            this.logger.alwaysLog(timeoutInMilliseconds + "ms is not a valid BOM wait time, using : " + timeout + "ms instead");
        }
        this.timeoutInMilliseconds = timeout;
        this.gson = gson;
        this.blackDuckBaseUrl = blackDuckBaseUrl;
    }

    public String getNoticesReportData(ProjectView project, ProjectVersionView version) throws InterruptedException, IntegrationException {
        this.logger.trace("Getting the Notices Report Contents using the Report Rest Server");
        return this.generateBlackDuckNoticesReport(version, ReportFormatType.TEXT);
    }

    public File createNoticesReportFile(File outputDirectory, ProjectView project, ProjectVersionView version) throws InterruptedException, IntegrationException {
        return this.createNoticesReportFile(outputDirectory, this.getNoticesReportData(project, version), project.getName(), version.getVersionName());
    }

    private File createNoticesReportFile(File outputDirectory, String noticesReportContent, String projectName, String projectVersionName) throws BlackDuckIntegrationException {
        File file;
        if (noticesReportContent == null) {
            return null;
        }
        String escapedProjectName = this.escapeUtil.replaceWithUnderscore(projectName);
        String escapedProjectVersionName = this.escapeUtil.replaceWithUnderscore(projectVersionName);
        File noticesReportFile = new File(outputDirectory, escapedProjectName + "_" + escapedProjectVersionName + "_Black_Duck_Notices_Report.txt");
        if (noticesReportFile.exists()) {
            noticesReportFile.delete();
        }
        FileWriter writer = new FileWriter(noticesReportFile);
        try {
            this.logger.trace("Creating Notices Report in : " + outputDirectory.getCanonicalPath());
            writer.write(noticesReportContent);
            this.logger.trace("Created Notices Report : " + noticesReportFile.getCanonicalPath());
            file = noticesReportFile;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new BlackDuckIntegrationException(e.getMessage(), e);
            }
        }
        writer.close();
        return file;
    }

    public ReportData getRiskReportData(ProjectView project, ProjectVersionView version) throws IntegrationException {
        HttpUrl originalProjectUrl = project.getHref();
        HttpUrl originalVersionUrl = version.getHref();
        ReportData reportData = new ReportData();
        reportData.setProjectName(project.getName());
        reportData.setProjectURL(this.getReportProjectUrl(originalProjectUrl));
        reportData.setProjectVersion(version.getVersionName());
        reportData.setProjectVersionURL(this.getReportVersionUrl(originalVersionUrl, false));
        reportData.setPhase(version.getPhase().toString());
        reportData.setDistribution(version.getDistribution().toString());
        ArrayList<BomComponent> components = new ArrayList<BomComponent>();
        this.logger.trace("Getting the Report Contents using the Aggregate Bom Rest Server");
        List<ProjectVersionComponentView> bomEntries = this.blackDuckApiClient.getAllResponses(version, ProjectVersionView.COMPONENTS_LINK_RESPONSE);
        boolean policyFailure = false;
        for (ProjectVersionComponentView ProjectVersionComponentView2 : bomEntries) {
            String policyStatus = ProjectVersionComponentView2.getApprovalStatus().toString();
            if (StringUtils.isBlank((CharSequence)policyStatus)) {
                HttpUrl componentPolicyStatusURL = null;
                componentPolicyStatusURL = !StringUtils.isBlank((CharSequence)ProjectVersionComponentView2.getComponentVersion()) ? this.getComponentPolicyURL(originalVersionUrl, ProjectVersionComponentView2.getComponentVersion()) : this.getComponentPolicyURL(originalVersionUrl, ProjectVersionComponentView2.getComponent());
                if (!policyFailure) {
                    try {
                        PolicyStatusView bomPolicyStatus = this.blackDuckApiClient.getResponse(componentPolicyStatusURL, PolicyStatusView.class);
                        policyStatus = bomPolicyStatus.getApprovalStatus().toString();
                    }
                    catch (IntegrationException e) {
                        policyFailure = true;
                        this.logger.debug("Could not get the component policy status, the Black Duck policy module is not enabled");
                    }
                }
            }
            BomComponent component = this.createBomComponentFromBomComponentView(ProjectVersionComponentView2);
            component.setPolicyStatus(policyStatus);
            this.populatePolicyRuleInfo(component, ProjectVersionComponentView2);
            components.add(component);
        }
        reportData.setComponents(components);
        LocalDateTime dateTime = this.getDateTimeOfLatestScanForProjectVersion(version, project.getName());
        reportData.setDateTimeOfLatestScan(dateTime);
        return reportData;
    }

    private LocalDateTime getDateTimeOfLatestScanForProjectVersion(ProjectVersionView projectVersion, String projectName) throws IntegrationException {
        List<CodeLocationView> codeLocations = this.blackDuckApiClient.getAllResponses(projectVersion, ProjectVersionView.CODELOCATIONS_LINK_RESPONSE);
        if (codeLocations.isEmpty()) {
            this.logger.info(String.format("Could not find any code locations for %s - %s", projectName, projectVersion.getVersionName()));
            return null;
        }
        Date dateOfLatestScan = (Date)Collections.max(codeLocations.stream().map(CodeLocationView::getUpdatedAt).collect(Collectors.toList()));
        return this.convertDateToLocalDateTime(dateOfLatestScan);
    }

    private LocalDateTime convertDateToLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public void createReportFiles(File outputDirectory, ProjectView project, ProjectVersionView version) throws IntegrationException {
        ReportData reportData = this.getRiskReportData(project, version);
        this.createReportFiles(outputDirectory, reportData);
    }

    public void createReportFiles(File outputDirectory, ReportData reportData) throws BlackDuckIntegrationException {
        try {
            this.logger.trace("Creating Risk Report Files in : " + outputDirectory.getCanonicalPath());
            RiskReportWriter writer = new RiskReportWriter();
            writer.createHtmlReportFiles(this.gson, outputDirectory, reportData);
        }
        catch (RiskReportException | IOException e) {
            throw new BlackDuckIntegrationException(e.getMessage(), e);
        }
    }

    public File createReportPdfFile(File outputDirectory, ProjectView project, ProjectVersionView version) throws IntegrationException {
        return this.createReportPdfFile(outputDirectory, project, version, document -> PDType1Font.HELVETICA, document -> PDType1Font.HELVETICA_BOLD);
    }

    public File createReportPdfFile(File outputDirectory, ProjectView project, ProjectVersionView version, FontLoader fontLoader, FontLoader boldFontLoader) throws IntegrationException {
        ReportData reportData = this.getRiskReportData(project, version);
        return this.createReportPdfFile(outputDirectory, reportData, fontLoader, boldFontLoader);
    }

    public File createReportPdfFile(File outputDirectory, ReportData reportData) throws BlackDuckIntegrationException {
        return this.createReportPdfFile(outputDirectory, reportData, document -> PDType1Font.HELVETICA, document -> PDType1Font.HELVETICA_BOLD);
    }

    public File createReportPdfFile(File outputDirectory, ReportData reportData, FontLoader fontLoader, FontLoader boldFontLoader) throws BlackDuckIntegrationException {
        try {
            this.logger.trace("Creating Risk Report Pdf in : " + outputDirectory.getCanonicalPath());
            RiskReportPdfWriter writer = new RiskReportPdfWriter(this.logger, fontLoader, boldFontLoader, Color.BLACK, 10.0f);
            File pdfFile = writer.createPDFReportFile(outputDirectory, reportData);
            this.logger.trace("Created Risk Report Pdf : " + pdfFile.getCanonicalPath());
            return pdfFile;
        }
        catch (RiskReportException | IOException e) {
            throw new BlackDuckIntegrationException(e.getMessage(), e);
        }
    }

    private HttpUrl getComponentPolicyURL(HttpUrl versionURL, String componentURL) throws IntegrationException {
        String componentVersionSegments = componentURL.substring(componentURL.indexOf("components"));
        return new HttpUrl(versionURL.string() + "/" + componentVersionSegments + "/policy-status");
    }

    private BomComponent createBomComponentFromBomComponentView(ProjectVersionComponentView bomEntry) {
        BomComponent component = new BomComponent();
        component.setComponentName(bomEntry.getComponentName());
        component.setComponentURL(bomEntry.getComponent());
        component.setComponentVersion(bomEntry.getComponentVersionName());
        component.setComponentVersionURL(bomEntry.getComponentVersion());
        component.setLicense(bomEntry.getLicenses().get(0).getLicenseDisplay());
        component.addSecurityRiskProfile(bomEntry.getSecurityRiskProfile());
        component.addLicenseRiskProfile(bomEntry.getLicenseRiskProfile());
        component.addOperationalRiskProfile(bomEntry.getOperationalRiskProfile());
        return component;
    }

    public void populatePolicyRuleInfo(BomComponent component, ProjectVersionComponentView bomEntry) throws IntegrationException {
        ProjectVersionComponentPolicyStatusType status;
        if (bomEntry != null && bomEntry.getApprovalStatus() != null && (status = bomEntry.getApprovalStatus()) == ProjectVersionComponentPolicyStatusType.IN_VIOLATION) {
            List<ComponentPolicyRulesView> rules = this.blackDuckApiClient.getAllResponses(bomEntry, ProjectVersionComponentView.POLICY_RULES_LINK_RESPONSE);
            ArrayList<PolicyRule> rulesViolated = new ArrayList<PolicyRule>();
            for (ComponentPolicyRulesView policyRuleView : rules) {
                PolicyRule ruleViolated = new PolicyRule(policyRuleView.getName(), policyRuleView.getDescription());
                rulesViolated.add(ruleViolated);
            }
            component.setPolicyRulesViolated(rulesViolated);
        }
    }

    private String getReportProjectUrl(HttpUrl projectURL) {
        if (projectURL == null) {
            return null;
        }
        String projectId = projectURL.string().substring(projectURL.string().lastIndexOf("/") + 1);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.blackDuckBaseUrl);
        urlBuilder.append("#");
        urlBuilder.append("projects/id:");
        urlBuilder.append(projectId);
        return urlBuilder.toString();
    }

    private String getReportVersionUrl(HttpUrl versionURL, boolean isComponent) {
        if (versionURL == null) {
            return null;
        }
        String versionId = versionURL.string().substring(versionURL.string().lastIndexOf("/") + 1);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.blackDuckBaseUrl);
        urlBuilder.append("#");
        urlBuilder.append("versions/id:");
        urlBuilder.append(versionId);
        if (!isComponent) {
            urlBuilder.append("/view:bom");
        }
        return urlBuilder.toString();
    }

    public String generateBlackDuckNoticesReport(ProjectVersionView version, ReportFormatType reportFormat) throws InterruptedException, IntegrationException {
        block5: {
            if (version.hasLink("licenseReports")) {
                try {
                    this.logger.debug("Starting the Notices Report generation.");
                    HttpUrl reportUrl = this.startGeneratingBlackDuckNoticesReport(version, reportFormat);
                    this.logger.debug("Waiting for the Notices Report to complete.");
                    ReportView reportInfo = this.isReportFinishedGenerating(reportUrl);
                    HttpUrl contentUrl = reportInfo.getFirstLink("content");
                    if (contentUrl == null) {
                        throw new BlackDuckIntegrationException("Could not find content link for the report at : " + reportUrl);
                    }
                    this.logger.debug("Getting the Notices Report content.");
                    String noticesReport = this.getNoticesReportContent(contentUrl);
                    this.logger.debug("Finished retrieving the Notices Report.");
                    this.logger.debug("Cleaning up the Notices Report on the server.");
                    this.deleteBlackDuckReport(reportUrl);
                    return noticesReport;
                }
                catch (IntegrationRestException e) {
                    if (e.getHttpStatusCode() == 402) {
                        this.logger.warn("Can not create the notice report, the Black Duck notice module is not enabled.");
                        break block5;
                    }
                    throw e;
                }
            }
            this.logger.warn("Can not create the notice report, the Black Duck notice module is not enabled.");
        }
        return null;
    }

    public HttpUrl startGeneratingBlackDuckNoticesReport(ProjectVersionView version, ReportFormatType reportFormat) throws IntegrationException {
        HttpUrl reportUrl = version.getFirstLink("licenseReports");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("reportFormat", reportFormat.toString());
        jsonObject.addProperty("reportType", ReportType.VERSION_LICENSE.toString());
        String json = this.blackDuckApiClient.convertToJson(jsonObject);
        Request request = this.blackDuckRequestFactory.createCommonPostRequestBuilder(reportUrl, json).build();
        return this.blackDuckApiClient.executePostRequestAndRetrieveURL(request);
    }

    public ReportView isReportFinishedGenerating(HttpUrl reportUrl) throws InterruptedException, IntegrationException {
        long startTime = System.currentTimeMillis();
        long elapsedTime = 0L;
        Date timeFinished = null;
        ReportView reportInfo = null;
        while (timeFinished == null && (timeFinished = (reportInfo = this.blackDuckApiClient.getResponse(reportUrl, ReportView.class)).getFinishedAt()) == null) {
            if (elapsedTime >= this.timeoutInMilliseconds) {
                String formattedTime = String.format("%d minutes", TimeUnit.MILLISECONDS.toMinutes(this.timeoutInMilliseconds));
                throw new BlackDuckIntegrationException("The Report has not finished generating in : " + formattedTime);
            }
            Thread.sleep(5000L);
            elapsedTime = System.currentTimeMillis() - startTime;
        }
        return reportInfo;
    }

    public String getNoticesReportContent(HttpUrl reportContentUrl) throws IntegrationException {
        JsonElement fileContent = this.getReportContentJson(reportContentUrl);
        return fileContent.getAsString();
    }

    private JsonElement getReportContentJson(HttpUrl reportContentUri) throws IntegrationException {
        JsonElement jsonElement;
        block8: {
            Response response = this.blackDuckApiClient.get(reportContentUri);
            try {
                String jsonResponse = response.getContentString();
                JsonObject json = (JsonObject)this.gson.fromJson(jsonResponse, JsonObject.class);
                JsonElement content = json.get("reportContent");
                JsonArray reportConentArray = content.getAsJsonArray();
                JsonObject reportFile = reportConentArray.get(0).getAsJsonObject();
                jsonElement = reportFile.get("fileContent");
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IntegrationException(e.getMessage(), e);
                }
            }
            response.close();
        }
        return jsonElement;
    }

    public void deleteBlackDuckReport(HttpUrl reportUri) throws IntegrationException {
        this.blackDuckApiClient.delete(reportUri);
    }
}

