#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
import os
import urllib2
import base64
import com.xebialabs.xlrelease.plugin.ansible.RemoteScript as RemoteScript
import com.xebialabs.xlrelease.plugin.ansible.JGitClient as JGitClient
from com.xebialabs.xlrelease.scm.connector import GitClient, GitConnectionSettings
class APIClient:

    def __init__(self, host, ansible_path, cmd_params):
        self.remote = RemoteScript(host)
        self.script = "%s  %s " % (ansible_path, cmd_params if cmd_params else '')

    def execute_playbook(self,play_book):
        response = self.remote.executePlayBook(play_book,self.script)
        APIClient.print_logs(response)
        return response

    def execute_command(self,command):
        response = self.remote.executeScript(command)
        APIClient.print_logs(response)
        return response

    def execute_local_playbook(self,play_book_path):
        response = self.execute_command(self.script + " " + play_book_path)
        APIClient.print_logs(response)
        return response

    @staticmethod
    def download_file(url, username, password):
        request=urllib2.Request(url)
        if (username is not None) and (password is not None):
            base64string = base64.encodestring('%s:%s' % (username, password))[:-1]
            auth_header =  "Basic %s" % base64string
            request.add_header("Authorization", auth_header)

        return urllib2.urlopen(request).read()

    @staticmethod
    def download_git_file(gitUrl, branch, gitPlaybookPath, gitConn):
        connectionSettings = GitConnectionSettings(gitUrl, branch,
                                                   gitConn.getProperty('authenticationMethod').name() if gitConn.getProperty('authenticationMethod') is not None else None,
                                                   gitConn.getProperty('username'),
                                                   gitConn.getProperty('password'),
                                                   gitConn.getProperty('domain'),
                                                   gitConn.getProperty('proxyHost'),
                                                   gitConn.getProperty('proxyPort'),
                                                   gitConn.getProperty('proxyUsername'),
                                                   gitConn.getProperty('proxyPassword'),
                                                   gitConn.getProperty('proxyDomain'),
                                                   None,
                                                   None)
        GitClient(connectionSettings)
        cloneDirpath = JGitClient.cloneRepository(gitUrl, branch)
        GitClient.removeCurrentGitConnectionSettings()
        gitPlaybookPath = gitPlaybookPath.lstrip("/")
        gitPlaybookPath = gitPlaybookPath.replace('/', os.sep)
        full_path = os.path.join(cloneDirpath, gitPlaybookPath)
        try:
            with open(full_path, 'r') as file:
                content = file.read()
        finally:
            JGitClient.deleteDirectory(cloneDirpath)
        return content

    @staticmethod
    def validate_input(task):
        playbook = task.pythonScript.getProperty('playbook')
        playbook_path = task.pythonScript.getProperty('playbookPath')
        playbook_url = task.pythonScript.getProperty('playbookUrl')
        gitConnection = task.pythonScript.getProperty('gitConnection')
        gitPlaybookPath = task.pythonScript.getProperty('gitPlaybookPath')

        sources = [playbook, playbook_path, playbook_url, gitConnection]
        non_none_sources = sum(1 for source in sources if source)
        if non_none_sources == 0:
            raise Exception('No source for playbook (Inline | URL | LocalPlaybook | Git) is provided.')
        elif non_none_sources > 1:
            raise Exception('Please provide only one source for playbook.')
        elif gitConnection and not gitPlaybookPath:
            raise Exception('gitPlaybookPath must be provided when gitConnection is specified.')

    @staticmethod
    def print_logs(response):
        if response.rc == 0:
            print "```"
            print response.stdout
            print "```"
        else:
            print "Exit code: "
            print response.rc
            print
            print "#### Output:"
            print "```"
            print response.stdout
            print "```"

            print "----"
            print "#### Error stream:"
            print "```"
            print response.stderr
            print "```"
            print

            sys.exit(response.rc)