import { DashboardView } from '@digital-ai/dot-components';
export { DashboardView } from '@digital-ai/dot-components';
import { ClientSettings, HttpConnection } from '@xlr-ui/app/types';
import { CardSearch } from '../ducks/analytics.reducer';
import { PropsForDashboard } from '@xlr-ui/app/features/custom-ui/window';

export interface AnalyticsCardData {
    contentText: string;
    embedConfig: EmbedConfig;
    embeddingId: string;
    externalId: number;
    folderFilter?: NativeFilterConfiguration;
    id: string;
    imageSrc: string;
    isFavorite: boolean;
    originalDashboard?: DashboardView;
    serverUrl: string;
    subtitle: string;
    tags: string[];
    title: string;
}

export interface IntelligenceHttpConnection extends HttpConnection {
    folderColumnName: string;
}

export interface AnalyticsClientSettings extends ClientSettings {
    setAnalyticsListFilters: (filter: CardSearch | undefined) => void;
}

export interface AccessTokenResponse {
    expiresAt: number;
    tokenValue: string;
}

export interface DashboardListResponse {
    entity: PlatformListDashboardWithPaginationResponse;
}

export interface DashboardGetResponse {
    entity: DashboardView;
}

export interface PlatformAuthor {
    full_name: string;
    id: string;
}

export interface PlatformMetadataResponse {
    authors: PlatformAuthor[];
    categories: string[];
}

export interface DashboardMetadataResponse {
    entity: PlatformMetadataResponse;
}

export interface PlatformUserResponse {
    entity: PlatformUser;
}

export interface PlatformUser {
    account: PlatformAccount;
    account_id: string;
    id: string;
    roles: string[];
    username: string;
}

export interface PlatformAccount {
    vanity_domain: string;
}

export interface NativeFilterConfigurationSource {
    id: string;
    type: number;
}

export interface NativeFilterConfiguration {
    key: string;
    name: string;
    source: NativeFilterConfigurationSource;
    summary: string;
}

export interface PlatformListDashboardWithPaginationResponse {
    pagination: PlatformListDashboardPagination;
    results: DashboardView[];
}

export interface PlatformListDashboardPagination {
    count: number;
    next_start: number | null;
    previous_start: number | null;
    start: number;
    total_available: number;
}

export type EmbedConfig = Omit<PropsForDashboard, 'placeholder'>;
