#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from argocd.argocd_rest_client import RestClient

response = RestClient(argo_server=argocdServer).getAppHistory(appName)
appStatus = response["status"]
currentRetryCount = currentRetryCount + 1

task.setStatusLine("Deleting Application '%s'" % appName)

if int(appStatus) < 400:
    if currentRetryCount < maxRetries:
        task.setStatusLine("Application '%s' is still deleting, Retry #%d" % (appName, currentRetryCount))
        task.schedule("argocd/waitForDeleteApplication.py", retryWaitTime)
    else:
        raise Exception("Status check retry exhausted.")
elif int(appStatus) > 500:
    raise Exception("Failed to connect to Argo CD server")
else:
    task.setStatusLine("Application '%s' deleted" % appName)
