import React from 'react';
import { DotAvatar, DotChip } from '@digital-ai/dot-components';
import { WithTitleAndId } from '@xlr-ui/app/types';
import { getSystemUserAvatar } from '../../helper';
import { SYSTEM_USER } from '../../../../constants';

export interface UserChipProps {
    className?: string;
    onDelete: (id: string) => void;
    value: WithTitleAndId;
}

export const UserChip = ({ className, value, onDelete }: UserChipProps) => {
    const { id, title } = value;
    return (
        <DotChip
            avatar={
                <DotAvatar
                    alt={`Image for user ${title}`}
                    imageSrc={getSystemUserAvatar(id)}
                    size="small"
                    text={title}
                    type={id === SYSTEM_USER ? 'image' : 'text'}
                />
            }
            className={className}
            key={id}
            onDelete={() => onDelete(id)}
            size="small"
        >
            {title}
        </DotChip>
    );
};
