import React, { createRef } from 'react';
import '@testing-library/jest-dom';
import { renderWithStoreAndTheme, screen } from '@xlr-ui/tests/unit/testing-utils';
import { DrawerHistorySkeletonRow, DrawerHistorySkeletonRowProps } from './drawer-history-skeleton-row.component';

describe('DrawerHistorySkeletonRow', () => {
    const observerTargetRef = createRef<HTMLDivElement>();

    const defaultProps: DrawerHistorySkeletonRowProps = {
        observerTarget: observerTargetRef,
    };

    const renderComponent = (props = defaultProps) => {
        return renderWithStoreAndTheme(<DrawerHistorySkeletonRow {...props} />);
    };

    it('should pass ref to the container div if observerTarget is provided', () => {
        renderComponent();
        expect(observerTargetRef.current).toHaveClass('drawer-history-skeleton-row');
    });

    it('should render skeletons with correct classes', () => {
        renderComponent();
        expect(screen.getByTestId('avatar-skeleton')).toHaveClass('MuiSkeleton-circular');
        expect(screen.getByTestId('header-user-skeleton')).toHaveClass('MuiSkeleton-text');
        expect(screen.getByTestId('header-time-skeleton')).toHaveClass('MuiSkeleton-text');
        expect(screen.getByTestId('row-data-skeleton-0')).toHaveClass('MuiSkeleton-text');
        expect(screen.getByTestId('row-data-skeleton-1')).toHaveClass('MuiSkeleton-text');
        expect(screen.getByTestId('row-data-skeleton-2')).toHaveClass('MuiSkeleton-text');
    });
});
