#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import time, sys, datetime
from com.versionone.apiclient import V1Connector
from com.versionone.apiclient import Services
from com.versionone.apiclient import Query
from com.versionone import Oid

from versionone import add_plan_record
from versionone import convert_to_datetime
from versionone.VersionOneClient import VersionOneClient
from versionone.PIListItemValues import PIListItemValues

global versionOneServer, resource, taskReportingApi, task

print ("Creating portfolio item...")
if versionOneServer is None:
    print("No VersionOne server provided.")
    sys.exit(1)

if versionOneServer['accessToken']:
    connector = V1Connector.withInstanceUrl(versionOneServer['url']+"/rest-1.oauth.v1/").withUserAgentHeader("XL Release", str(time.time())).withAccessToken(versionOneServer['accessToken']).build()
else:
    connector = V1Connector.withInstanceUrl(versionOneServer['url']+"/rest-1.oauth.v1/").withUserAgentHeader("XL Release", str(time.time())).withUsernameAndPassword(versionOneServer['username'], versionOneServer['password']).build()

services = Services(connector)
v1Client = VersionOneClient.create_v1Client( versionOneServer )

project_oid = services.getOid(projectId)
print("Project OId=%s") % project_oid

asset_type = services.getMeta().getAssetType("Epic")
new_pi = services.createNew(asset_type, project_oid)
print("Portfolio item=%s") % new_pi

if not title:
    print("Portfolio item title is required.")
    sys.exit(1)
print("Portfolio item title=%s") % title

piListItems = PIListItemValues()

attribute_definition = asset_type.getAttributeDefinition("Name")
new_pi.setAttributeValue(attribute_definition, title)

for key, value in attributes.iteritems():
    print("key=%s, value=%s") %(key, value)
    if key == "Tags":
        key = "TaggedWith"
    elif key == "Type":
        key = "Category"
    elif key == "Business Value" or key == "BusinessValue":
        key = "Value"
    elif key == "Risk Scale" or key == "RiskScale":
        key = "Risk"
    elif key == "Planned Begin" or key == "PlannedBegin":
        key = "PlannedStart"
    elif key == "Portfolio Item" or key == "PortfolioItem":
        key = "Super"
    attribute_definition = asset_type.getAttributeDefinition(key)
    if attribute_definition.isMultiValue():
        if value.count(",") > 0:
            numberVal = value.split(",")
            print("key=%s, MultiValue=%s") %(key,numberVal)
            for numberValValue in numberVal:
                numberValValue = numberValValue.strip()
                if numberValValue.count(":") > 0 :
                    oid = Oid.fromToken(numberValValue, services.getMeta())
                    new_pi.addAttributeValue(attribute_definition, oid)
                else :
                    new_pi.addAttributeValue(attribute_definition, numberValValue)
        else:
            if value.count(":") > 0 :
                oid = Oid.fromToken(value, services.getMeta())
                new_pi.addAttributeValue(attribute_definition, oid)
            else :
                new_pi.addAttributeValue(attribute_definition, value)
    elif v1Client.get_list_item_type(key):
        token = ""
        if key == "Priority" or key == "Status" or key == "Category":
            token = "Epic"+v1Client.get_list_item_type(key)
        elif key == "Source":
            token = "Story"+v1Client.get_list_item_type(key)
        else:
            token = v1Client.get_list_item_type(key)
        asstType = services.getMeta().getAssetType(token)
        newAsset = services.createNew(asstType, project_oid)
        newAsset.setAttributeValue(asstType.getAttributeDefinition("Name"), value)
        if value.count(":") > 0:
            newAsset.setOid(Oid.fromToken(value, services.getMeta()))
        else:
            newAsset.setOid(Oid.fromToken(piListItems.oids[key+value], services.getMeta()))
        new_pi.setAttributeValue(attribute_definition, newAsset.getOid())
    else:
        new_pi.setAttributeValue(attribute_definition, value)

services.save(new_pi)

_assetType = services.getMeta().getAssetType("Epic")
_query = Query(new_pi.getOid())

_nameAttribute = _assetType.getAttributeDefinition("Name")
_numberAttribute = _assetType.getAttributeDefinition("Number")
_createDateAttribute = _assetType.getAttributeDefinition("CreateDate")
_createdByAttribute = _assetType.getAttributeDefinition("CreatedBy")

_query.getSelection().add(_nameAttribute)
_query.getSelection().add(_numberAttribute)
_query.getSelection().add(_createDateAttribute)
_query.getSelection().add(_createdByAttribute)

_result = services.retrieve(_query)
_pi = _result.getAssets()[0]

_pi_name = _pi.getAttribute(_nameAttribute).value
_pi_number = _pi.getAttribute(_numberAttribute).value
_pi_create_date_str = str(_pi.getAttribute(_createDateAttribute).value)
_pi_create_date = convert_to_datetime(_pi_create_date_str)
_pi_created_by = str(_pi.getAttribute(_createdByAttribute).value)

print("PI Number=%s, PI Name=%s, PI Created Date=%s, PI Created By=%s") %(_pi_number, _pi_name, _pi_create_date, _pi_created_by)
print("PI OId=%s, PI=%s") %(new_pi.getOid(), new_pi)
token = new_pi.getOid().getToken()
portfolioItemNumber = _pi_number

ticket = ""
title = ""
pi_url = ""
data = {}
versionOneServerUrl = versionOneServer['url']
updatedDate = datetime.datetime.now()
updatedBy = versionOneServer['username']

if token:
    tokenData = token.split(":")
    asset_type = tokenData[0]
    pi_oid = tokenData[1]
    pi_url = versionOneServerUrl + "/Epic.mvc/Summary?oidToken=Epic%3A" + pi_oid
    data["Token"] = token
    data["PortfolioItemNumber"] = portfolioItemNumber
    data["PortfolioItemURL"] = pi_url
    print(data)

    for key, value in attributes.iteritems():
        print("Attribute key [%s] with value [%s]\n" % (key, value))

    add_plan_record(task_reporting_api=taskReportingApi, task=task,
                    versionOneServer=versionOneServer, ticket=_pi_number,
                    title=_pi_name, ticketType=asset_type, ticketUrl=pi_url, status="PASSED",
                    updatedDate=_pi_create_date, updatedBy=_pi_created_by)
else:
    add_plan_record(task_reporting_api=taskReportingApi, task=task,
                    versionOneServer=versionOneServer, ticket=ticket,
                    title=title, ticketType=asset_type, ticketUrl="Not Available", status="FAILED",
                    updatedDate=updatedDate, updatedBy=updatedBy)