#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys, traceback, time
from versionone.VersionOneClient import VersionOneClient

try:
    v1Client = VersionOneClient.create_v1Client(versionOneServer)
    results = v1Client.getAssets(assetType, whereClause)
    numberOfResult = results['total']
    print "\n Number Of Result(s)=%s" % (numberOfResult)
    data = {}
    matchedStatus = 0
    if(numberOfResult > 0 ):
        assets = results['Assets']
        for asset in assets:
            print(asset['Attributes']['Name'])
            assetName = asset['Attributes']['Name']['value']
            print(asset['Attributes']['Number'])
            assetNumber = asset['Attributes']['Number']['value']
            print(asset['Attributes']['Status.Name'])
            assetStatus = asset['Attributes']['Status.Name']['value']
            if(assetStatus is None):
                assetStatus = "None"
            if (assetStatus in expectedStatusList):
                data[assetNumber] = "%s | %s " % (assetName, assetStatus)
                matchedStatus += 1
        if(matchedStatus == numberOfResult):
            print "\n Number Of Ticket(s) Found: %s" % (len(data))
            print(data)
        else:
            print "\n Ticket(s) Do Not Match Expected Status , Retrying"
            task.schedule("versionone/checkQuery.py" ,pollInterval)
    # End If


except:
    traceback.print_exc(file=sys.stdout)
    sys.exit(1)
    # End try
