import React from 'react';
import { Provider } from 'react-redux';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { store } from '../';
import { TemplateTileComponent, TemplateTileProps } from './template-tile.component';

export const TemplateTile = ({ description, title }: TemplateTileProps) => {
    return (
        <DotThemeProvider>
            <Provider store={store}>
                <TemplateTileComponent description={description} title={title} />
            </Provider>
        </DotThemeProvider>
    );
};
